#include <iostream>
#include <vector>
#include <algorithm>
#include <string>

using namespace std;


typedef pair<int64_t, string> coord;

static constexpr unsigned max_n = 1e4;

int main(void) {
  unsigned T, test = 1;
  cin >> T;
  while (T--) {
    int64_t U;
    cin >> U;
    uint32_t freq[26], begin[26];
    for (unsigned index = 0; index != 26; ++index) {
      freq[index] = 0;
      begin[index] = 1;
    }
    uint32_t map[10];
    vector<coord> sorted;
    for (unsigned index = 0; index != max_n; ++index) {
      int64_t code;
      string input;
      cin >> code >> input;
      sorted.push_back(make_pair(code, input));
      //cout << "input=" << input << endl;
      begin[input[0] - 'A'] = 0;
      for (auto c : input) {
        freq[c - 'A']++;
      }
    }
    auto index = 0;
    vector<uint32_t> start;
    for (char c = 'A'; c <= 'Z'; ++c) {
      if (freq[c - 'A']) {
        map[index++] = c - 'A';
      }
      if (freq[c - 'A'] && begin[c - 'A']) {
        start.push_back(c - 'A');
      }
    }
    
    int64_t max1 = 1, count = U;
    while (count--)
      max1 *= 10;
    max1--;
      
    for (auto choose : start) {
      //cerr << "try with" << (char)('A' + choose) << endl;
      uint32_t tmp[9];
      for (unsigned index = 0, ptr = 0; index != 10; ++index) {
        if (map[index] != choose)
          tmp[ptr++] = map[index];
      }
      
      sort(tmp, tmp + 9);
      uint32_t reverse[26];
#if 0
      auto printMap = [&]() -> void {
        for (unsigned index = 0; index != 10; ++index)
          cout << (char)('A' + map[index]) << " ";
        cout << endl;
      };
#endif 
      //printMap();
      //cerr << "max=" << max1 << endl;
      do {
        // printMap();
        bool good = true;
        for (unsigned index = 0; index != 9; ++index)
          reverse[tmp[index]] = index + 1;
        reverse[choose] = 0;
        for (auto elem : sorted) {
          int64_t number = 0;
          for (char c : elem.second) {
            number = number * 10 + reverse[c - 'A'];
          }
          if (elem.first == -1) {
            if (number > max1) {
              good = false;
              break;
            }
          } else {
            if (number > elem.first) {
              good = false;
              break;
            }
          }
        }
        if (good) {
          cout << "Case #" << (test++) << ": ";
          cout << (char)('A' + choose);
          for (unsigned index = 0; index != 9; ++index)
            cout << (char)('A' + tmp[index]);
          cout << endl;
        }
      } while (std::next_permutation(tmp, tmp + 9));
    }
  }
  return 0;
}
