#include <iostream>
#include <algorithm>
#include <vector>
#include <string>
#include <map>
#include <set>

using namespace std;

struct charAndInt
{
    char c;
    long long int x;
};

struct komparator
{
    inline bool operator () (const charAndInt & p1, const charAndInt & p2)
    {
        return p1.x > p2.x;
    }
};

void testCase(long long int testNum)
{
    long long int U;
    cin >> U;
    long long int ALL_PAIRS = 10000;
    map<char, long long int> mapa;
    set<char> allChars;
    for (long long int i = 0; i < ALL_PAIRS; i++)
    {
        long long int x;
        string s;
        cin >> x >> s;
        mapa[s[0]]++;
        for (auto c : s)
        {
            allChars.insert(c);
        }
    }
    vector<charAndInt> wektor;
    for (auto it = mapa.begin(); it != mapa.end(); it++)
    {
        wektor.push_back({it->first, it->second});
    }
    sort(wektor.begin(), wektor.end(), komparator());
    char missing;
    for (auto it = allChars.begin(); it != allChars.end(); it++)
    {
        bool found = false;
        for (long long int i = 0; i < wektor.size(); i++)
        {
            if (wektor[i].c == *it)
            {
                found = true;
                break;
            }
        }
        if (!found)
        {
            missing = *it;
            break;
        }
    }
    cout << "Case #" << testNum << ": " << missing;
    for (long long int i = 0; i<wektor.size(); i++)
    {
        cout << wektor[i].c;
    }
    cout << "\n";
}


int main(void)
{
    ios_base::sync_with_stdio(0);
    long long int tests;
    cin >> tests;
    for (long long int t = 1; t<=tests; t++)
        testCase(t);
    return 0;
}
