#include <iostream>
#include <vector>
#include <tuple>
#include <set>
#include <map>
#include <algorithm>

using namespace std;

string solution(int u, vector<pair<string, string>> &d)
{
    sort(
        d.begin(),
        d.end(),
        [](const pair<string, string> &a, const pair<string, string> &b) -> bool { return stoi(a.first) < stoi(b.first); });
    map<char, char> lessorequal;
    set<char> usedChars;
    map<char, char> found;

    //while (lessorequal.size() < 10)
    {
        for (auto a: d)
        {
            for (auto c: a.second)
            {
                lessorequal[c] = '~';
                usedChars.insert(c);
            }
        }
    }

    char minFound = '0' - 1;
    char maxFound = '9' + 1;
    for(auto a: d)
    {
        if (a.first.size() == a.second.size())
        {
            char l = a.first[0];
            char v = a.second[0];
            if (l < lessorequal[v])
            {
                lessorequal[v] = l;
//                cout << v << " <= " << l << endl;
            }
            lessorequal[v] = min(lessorequal[v], l);
        }
    }

    int untouched = 0;
    char untouchedChar;
    int nineCandidates = 0;
    char nineChar;

    for (auto a: lessorequal)
    {
        if (a.second == '~')
        {
            ++ untouched;
            untouchedChar = a.first;
        }
        if (a.second == '9')
        {
            ++nineCandidates;
            nineChar = a.first;
        }

    }

//    cout << "untouched " << untouchedChar << "  " << untouched << endl;
    if (untouched == 1)
    {
        lessorequal[untouchedChar] = '0';
        found[untouchedChar] = '0';
        minFound = '0';
    }
    if (nineCandidates == 1)
    {
        lessorequal[nineChar] = '9';
        found[nineChar] = '9';
        maxFound = '9';
    }


    if (minFound >= '0') {
        bool increased = true;
        while (increased)
        {
            increased = false;
            for(auto a: lessorequal)
            {
                if (a.second == minFound + 1)
                {
//                    cout << "found " << a.first << " to be " << a.second << endl;
                    found[a.first] = a.second;
                    ++minFound;
                    increased = true;
                    break;
                }
            }
        }
    }


    string result = "##########";
//    cout << result << endl;
    // for(auto a: lessorequal)
    // {
    //     if (a.second == '~') a.second = '0';
    //     result[a.second - '0'] = a.first;
    //     cout << result << endl;
    // }

    for (auto a: found)
    {
        result[a.second - '0'] = a.first;
//        cout << result << endl;
    }

    return result;
}

int main(int argc, char* argss[])
{
    int T;
    cin >> T;
    for(int i = 0; i != T; ++i)
    {
        int U;
        cin >> U;
        vector<pair<string, string>> d;
        for (int j = 0; j != 10000; ++j)
        {
            string q, r;
            cin >> q >> r;
            d.emplace_back(q, r);
        }
        string r = solution(U, d);
        cout << "Case #" << i+1 << ": " << r << endl;
    }

    return 0;
}