#include <algorithm>
#include <cstdio>
#include <cstring>
#include <iostream>
#include <utility>

using namespace std;
using i64 = long long;

constexpr int MAX = 10010;
constexpr int MAXC = 128;

char k[MAX][32], v[MAX][32], key[16], dic[16];
int ans[MAXC], cnt[MAXC];
i64 m[MAX];

void FindKey(int n) {
  memset(cnt, 0, sizeof(cnt));
  for (int i = 0; i < n; ++i) {
    for (int j = 0; v[i][j]; ++j) {
      ++cnt[v[i][j]];
    }
  }
  int s = 0;
  for (int i = 0; i < MAXC; ++i) {
    if (cnt[i]) {
      // printf("i = %d\n", i);
      key[s++] = i;
    }
  }
}

char Find0(int n) {
  memset(cnt, 0, sizeof(cnt));
  for (int i = 0; i < n; ++i) {
    ++cnt[v[i][0]];
  }
  for (int i = 0; i < 10; ++i) {
    if (!cnt[key[i]]) {
      ans[key[i]] = 0;
      return key[i];
    }
  }
  return -1;
}

char Find(int n, int x) {
  memset(cnt, 0, sizeof(cnt));
  for (int i = 0; i < n; ++i) {
    if (k[i][0] != x + '0' || strlen(k[i]) != strlen(v[i])) continue;
    // printf("x = %d, k = %lld, v = %s\n", x, m[i], v[i]); 
    if (ans[v[i][0]] == -1) {
      ans[v[i][0]] = x;
      // printf("%d = %c\n", x, v[i][0]);
      return v[i][0];
    }
  }
  return -1;
}

int main() {
  int t, u, n = 10000;
  scanf("%d", &t);
  for (int ct = 1; ct <= t; ++ct) {
    scanf("%d", &u);
    for (int i = 0; i < n; ++i) {
      scanf("%lld", &m[i]);
      sprintf(k[i], "%lld", m[i]);
      scanf("%s", v[i]);
    }
    memset(ans, -1, sizeof(ans));
    FindKey(n);
    Find0(n);
    for (int i = 1; i < 10; ++i) {
      Find(n, i);
    }
    for (int i = 0; i < 10; ++i) {
      dic[ans[key[i]]] = key[i];
    }
    dic[10] = 0;
    printf("Case #%d: %s\n", ct, dic);
  }
  return 0;
}
