#include <iostream>
#include <vector>
#include <string>
#include <unordered_map>
#include <unordered_set>
#include <algorithm>
#include <unordered_map>

using namespace std;

template <class T>
std::ostream& operator<<(std::ostream& os, const vector<T>& X)
{
    for (auto&& x : X)
        os << x << ' ';
    
    return os;
}

template <class T>
std::ostream& operator<<(std::ostream& os, const vector<vector<T>>& X)
{
    os << '\n';
    for (auto&& x : X)
        os << x << '\n';
    
    return os;
}

double super_map(vector<int>& A)
{
    double r = 0.0;
    double p = 1.0;
    for (int i = 0; i < A.size(); ++i)
    {
        r += p*A[i];
        p *= 10.0;
    }
    return r;
}


struct CharAndVec
{
    CharAndVec(char c_, vector<int> l_) : c(c_), L(l_) 
    {
        a = super_map(L);
    }
    
    char c;
    vector<int> L;
    double a;
};

std::ostream& operator<<(std::ostream& os, const CharAndVec& X)
{
    os << X.c << ": " << X.L << " | " << X.a;
    return os;
}


bool operator<(const CharAndVec& A, const CharAndVec& B)
{
    return A.a > B.a;
}

struct Solver
{
    Solver(long U) : U(U), D(26), Z(U,0)
    {
        for (char x = 'A'; x <= 'Z'; ++x)
        {
            D[int(x)-'A'] = vector<int>(U,0);
        }
    }
    
    void process_query(long Q, const string& s)
    {
        int i = 0;
        for (char c : s)
        {
            if (c < 'A' || c > 'Z')
                continue;
            ++D[int(c)-'A'][i];
            
            ++i;
        }
        
        for (int i = s.size(); i < U; ++i)
        {
            ++Z[i];
        }
    }
    
    
    
    vector<CharAndVec> super_sort() const
    {
        vector<CharAndVec> result;
        
        char a = 'A';
        for (auto d : D)
        {
            if (d != vector<int>(U,0))
            {
                result.push_back(CharAndVec(a,d));
            }
            
            ++a;
        }
        
        std::sort(result.begin(), result.end());
        
        return result;
    }
    
    int determine_0()
    {
        int i = 0;
        for (auto d : D)
        {
            if (d != vector<int>(U,0))
            {
               if (d.back() == 0)
                   return i;
            }            
            ++i;
        }
        cout << "SHIT" << endl;
        return 0;
    }
    
    void add_to_z(int z)
    {
        for (int i = 0; i < U; ++i)
        {
            D[z][i] += Z[i]*10;
        }
    }
    
    string Solve() 
    {
        int z = determine_0();
        add_to_z(z);
        
        char x = 0;
        
        auto Q = super_sort();
        
        string result;
        
        for (auto q : Q)
        {
//             cout << q << endl;
            result.push_back(q.c);
            ++x;
        }
        return result;
    }
    
    long U;
    vector<vector<int>> D;
    
    vector<int> Z;
};

int main() 
{
    
    std::ios_base::sync_with_stdio(false);
    long T;
	cin >> T;
	for (long t = 0; t < T; ++t)
	{
		cout << "Case #" << t+1 << ": ";
		
        
        long U;
        cin >> U;
        
        Solver S(U);
        
        for (long i = 0; i < 10000; ++i)
        {
            long Q;
            cin >> Q;
            
            string R;
            
            cin >> R;
            
            std::reverse(R.begin(), R.end());
//             while(R.size() != U)
//                 R.push_back('?');
            
            S.process_query(Q,R);
        }
        
        cout << S.Solve() << endl;
        
//         cout <<  << endl;
	}
    return 0;
}
