#include <iostream>
#include <string>
#include <string.h>
#include <algorithm>

using namespace std;

const int MAXN = 10011;

typedef long long ll;

int U;
ll Q[MAXN];
string R[MAXN];
int cnt[26];
int perm[11];
int cm[26];

ll cal(int i) {
    ll res = 0;
    if (cm[R[i][0] - 'A'] == 0) {
        return 0;
    }
    for (int j = 0; j < R[i].length(); ++j) {
        res = res * 10LL + cm[R[i][j] - 'A'];
    }
    return res;
}

void solve() {
    ll limit = 1;
    for (int i = 0; i < U; ++i) {
        limit *= 10;
    }
    --limit;
    string origin;
    for (int i = 0; i < 26; ++i) {
        cm[i] = 0;
        if (cnt[i] > 0) {
            origin.push_back('A' + i);
        }
    }
    for (int i = 0; i < 10; ++i) {
        perm[i] = i;
    }
    do {
        for (int i = 0; i < 10; ++i) {
            cm[origin[perm[i]] - 'A'] = i;
        }
        bool ok = true;
        for (int i = 0; i < 10000 && ok; ++i) {
            ll val = cal(i);
            if (val < 1) {
                ok = false;
                break;
            }
            if (Q[i] == -1) {
                if (val > limit) {
                    ok = false;
                    break;
                }
            } else if (val > Q[i]) {
                ok = false;
                break;
            }
        }
        if (ok) break;
    } while (next_permutation(perm, perm + 10));
    for (int i = 0; i < 10; ++i) {
        cout << origin[perm[i]];
    }
    cout << endl;
}

int main() {
    ios::sync_with_stdio(false);
    int t;
    cin >> t;
    for (int cas = 1; cas <= t; ++cas) {
        memset(cnt, 0, sizeof(cnt));
        cin >> U;
        for (int i = 0; i < 10000; ++i) {
            cin >> Q[i] >> R[i];
            for (int j = 0; j < R[i].length(); ++j) {
                ++cnt[R[i][j] - 'A'];
            }
        }
        cout << "Case #" << cas << ": "; 
        solve();
    }
    return 0;
}
