#include <iostream>
#include <vector>
#include <algorithm>
#include <sstream>

using namespace std;
vector<int> get_expected_order(int u)
{
    return { 0, 9, 8, 7, 6, 5, 4, 3, 2, 1 };
}

void solve()
{
    int u;
    cin >> u;

    auto expected_order = get_expected_order(u);

    vector<int> first_char_freqs(26);
    vector<bool> char_occurs(26);

    for (int i = 0; i < 10000; ++i)
    {
        string q, r;
        cin >> q >> r;

        first_char_freqs[r[0] - 'A'] += 1;

        for (char c : r)
        {
            char_occurs[c - 'A'] = true;
        }
    }

    string used_chars;
    for (char c = 'A'; c <= 'Z'; ++c)
    {
        if (char_occurs[c - 'A'])
        {
            used_chars.push_back(c);
        }
    }

    sort(used_chars.begin(), used_chars.end(), [&](char a, char b) {
        return first_char_freqs[a - 'A'] < first_char_freqs[b - 'A'];
    });

    for (int i = 0; i < 10; ++i)
    {
        cout << used_chars[expected_order[i]];
    }
    cout << '\n';
}

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    cin >> t;

    for (int tc = 1; tc <= t; ++tc)
    {
        cout << "Case #" << tc << ": ";
        solve();
    }
}