#include <algorithm>
#include <cstdio>
#include <cstring>
#include <map>
#include <set>
#include <vector>
using namespace std;

struct Par {
  char letter;
  int count;
  Par(char _letter, int _count): letter(_letter), count(_count) {}
};

int u;

bool cmp(const Par& first, const Par& second) {
  return first.count > second.count;
}

void solve() {
  set<char> heads;
  set<char> all;
  map<char, int> count;
  char output[20];

  scanf("%d", &u);
  for (int i = 0; i < 10000; ++i) {
    int a;
    scanf("%d%s", &a, output);

    heads.insert(output[0]);
    count[output[0]]++;
    for (int j = 0; j < strlen(output); ++j) {
      all.insert(output[j]);
    }
  }

  set<char> diff;
  set_difference(all.begin(), all.end(), heads.begin(), heads.end(), inserter(diff, diff.end()));

  printf("%c", *diff.begin());
  count.erase(*diff.begin());

  vector<Par> vec;
  for (auto pair : count) {
    vec.push_back(Par(pair.first, pair.second));
  }

  sort(vec.begin(), vec.end(), cmp);

  for (auto pair : vec) {
    printf("%c", pair.letter);
  }

  printf("\n");
}

int main(void) {
  int t;
  scanf("%d", &t);

  for (int i = 1; i <= t; ++i) {
    printf("Case #%d: ", i);
    solve();
  }

  return 0;
}
