#include <cstdio>
#include <cstring>

const int all_maps = 0x3ff;
const int n = 10000;

struct letter_t {
  int mapping;
  bool used;
  bool solved;
  int value;
  void is_not(int v) {
    mapping &= ~(1<<v);
  }
  void leq(int v) {
    for(int i=0; i<10; ++i) {
      if (i>v)
        mapping &= ~(1<<i);
    }
  }
  bool can_be(int v) {
    return mapping & (1<<v);
  }
  int count() {
    int s=0;
    for(int i=0; i<10; ++i)
      if (mapping & (1<<i))
        ++s;
    return s;
  }
} letter[26];

struct guess_t {
  char input[20];
  char output[20];
} g[n];

char solution[11];
int missing;

void clear() {
  missing = 10;
  for(int i=0; i<26; ++i) {
    letter[i].mapping = all_maps;
    letter[i].used = false;
    letter[i].solved = false;
  }
  for(int j=0; j<10; ++j) {
    solution[j] = '?';
  }
  solution[10] = 0;
}

bool find_number(int v) {
  bool found = false;
  int l = -1;
  for(int i=0; i<26; ++i) {
    if (letter[i].used && letter[i].can_be(v)) {
      if (found)
        return false;
      else {
        found = true;
        l = i;
      }
    }
  }
  if (found) {
    --missing;
    solution[v] = 'A' + l;
    letter[l].solved = true;
    letter[l].value = v;
  }
  return found;
}
void apply_guess_binds(int p) {
  if (g[p].input[0] != '-') {
    if (strlen(g[p].input) == strlen(g[p].output)) {
      for(int i=0; g[p].input[i]; ++i) {
        if (letter[g[p].output[i]-'A'].solved) {
          if (letter[g[p].output[i]-'A'].value < g[p].input[i] - '0')
            break;
        }
        else {
          letter[g[p].output[i]-'A'].leq(g[p].input[i] - '0');
          break;
        }
      }
    }
  }
}
int find_bound_letter() {
  for(int i=0; i<26; ++i) {
    if (letter[i].used && !letter[i].solved && letter[i].count() == 1)
      return i;
  }
  return -1;
}
void apply_letter_bind(int l) {
  int v;
  --missing;
  letter[l].solved = true;
  for(int i=0; i<10; ++i)
    if (letter[l].can_be(i)) {
      v = i;
      letter[l].value = i;
      solution[v] = 'A' + l;
    }
  for(int i=0; i<26; ++i)
    if (i!=l)
      letter[i].is_not(v);
}

void solve(int test) {
  clear();
  int u;
  scanf(" %d", &u);
  for(int i=0; i<n; ++i) {
    scanf(" %s %s", g[i].input, g[i].output);
    for(int j=0; g[i].output[j]; ++j)
      letter[g[i].output[j]-'A'].used = true;
    letter[g[i].output[0]-'A'].is_not(0);
  }
  for(int i=0; i<30; ++i) {
    for(int j=0; j<10; ++j) {
      find_number(j);
    }
    for(int j=0; j<n; ++j) {
      apply_guess_binds(j);
    }
    while(true) {
      int l = find_bound_letter();
      if (l == -1)
        break;
      apply_letter_bind(l);
    }
    if (missing <= 0)
      break;
  }
  printf("Case #%d: %s\n", test, solution);
}

int main() {
  int tests;
  scanf(" %d", &tests);
  for(int i=1; i<=tests; ++i) {
    solve(i);
  }
  return 0;
}
