#include <bits/stdc++.h>

using namespace std;

const int MAX_TESTS = 100;
const int NUM_OF_INPUTS = 10000;
const int NUM_OF_ALPHABETS = 26;

int compare(pair<int, int> a, pair<int, int> b) {
    return a.second > b.second;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int numOfTests;
    cin >> numOfTests;

    for (int testIdx = 0; testIdx < numOfTests; ++testIdx) {
        string solution;
        int U;
        vector<pair<int, int>> counts;
        vector<pair<int, int>> firstCounts;
        for (int i = 0; i < NUM_OF_ALPHABETS; ++i) {
            counts.emplace_back(i, 0);
            firstCounts.emplace_back(i, 0);
        }

        cin >> U;
        for (int i = 0; i < NUM_OF_INPUTS; ++i) {
            string q, digits;
            cin >> q >> digits;
            firstCounts[digits[0] - 'A'].second += 1;
            for (int j = 0; j < digits.size(); ++j) {
                counts[digits[j] - 'A'].second += 1;
            }
        }

        sort(counts.begin(), counts.end(), compare);
        sort(firstCounts.begin(), firstCounts.end(), compare);

        vector<int> nonzeros(NUM_OF_ALPHABETS);
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (counts[i].first == counts[j].first) {
                    nonzeros[i] = 1;
                    break;
                }
            }
        }
        int zeroIdx;
        for (int i = 0; i < 10; ++i) {
            if (nonzeros[i] == 0) {
                zeroIdx = i;
                break;
            }
        }
        solution.push_back(counts[zeroIdx].first + 'A');
        for (int i = 0; i < 10; ++i) {
            if (i != zeroIdx) {
                solution.push_back(counts[i].first + 'A');
            }
        }

        cout << "Case #" << (testIdx + 1) << ": " << solution << '\n';
    }

    return 0;
}