#include <iostream>
#include <vector>
#include <algorithm>
#include <cstring>
#include <map>
#include <queue>
#include <cassert>

using namespace std;

int U;
string Q[10001];
string R[10001];

map<char,int> upperBounds;
map<char,bool> notZero;

string solve() {
    string D;
    bool used[256];
    memset(used,false,sizeof(used));
    map<char,int> nHead;

    for(int i=0; i<10000; i++) {
        char c0 = R[i][0];
        nHead[c0]++;
        for(int j=0; j<R[i].size(); j++) {
            used[R[i][j]] = true;
        }
    }

    // Add 0
    for(char c='A'; c<='Z'; c++) {
        if(used[c]) {
            //printf("used: %c\n",c);
            if(nHead[c]==0) {
                // printf("nHead[%c] = %d\n",c,nHead[c]);
                D += c;
            }
        }
    }

    // Add 1~9
    vector<pair<char,int>> headCountsPairs;
    for(auto p : nHead) {
        if(nHead[p.first] > 0)
            headCountsPairs.push_back(p);
    }
    // cout << " nPairs:" << headCountsPairs.size() << endl;
    assert(headCountsPairs.size()==9);

    sort(headCountsPairs.begin(), headCountsPairs.end(),
        [](pair<char,int> a, pair<char,int> b) {
            return a.second > b.second;
        });


    for(int i=0; i<9; i++) {
        D += headCountsPairs[i].first;
    }
    return D;
}

int main() {
    int T;
    scanf("%d", &T);
    for(int t=1; t<=T; t++) {
        scanf("%d", &U);
        for(int i=0; i<10000; i++) {
            cin >> Q[i];
            cin >> R[i];
        }
        string D = solve();
        printf("Case #%d: %s\n", t, D.c_str());
    }
}