#include <cassert>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <string>
#include <algorithm>
#include <map>
#include <regex>
#include <set>
#include <vector>

void strrev(char *s) {
    size_t l = strlen(s);

    for (size_t k = 0; k < l / 2; k++) {
        std::swap(s[k], s[l - k - 1]);
    }
}

int main(int argc, char **argv) {
    int T;
    scanf("%d", &T);

    for (int t = 1; t <= T; t++) {
        int U;
        scanf("%d", &U);
        static char lines[10000][20];
        static char answer[11];

        for (int i = 0; i < 10000; i++) {
            scanf("%*s %s", lines[i]);
            strrev(lines[i]);
        }

        std::map<char, long long> stat;
        std::set<char> nz;

        for (int i = 0; i < 10000; i++) {
            long long m = 1;
            char c;
            int j;
            for (j = 0; lines[i][j]; j++) {
                c = lines[i][j];
                stat[c] += m;
                m *= 10;
            }
            if (j > 1) {
                nz.insert(c);
            }
        }

        std::vector<std::pair<long long, char>> rstat;

        if (nz.size() != 9) {
            return 1;
        }

        for (auto it : stat) {
            if (nz.find(it.first) == nz.end()) {
                answer[0] = it.first;
            } else {
                rstat.push_back(std::make_pair(it.second, it.first));
            }
        }

        std::sort(rstat.rbegin(), rstat.rend());

        for (int i = 0; i < 9; i++) {
            answer[i + 1] = rstat[i].second;
        }
        answer[10] = 0;

        printf("Case #%d: %s\n", t, answer);
    }

    return 0;
}
