#include <vector>
#include <algorithm>
#include <cstdio>
#include <iostream>
#include <sstream>
#include <set>
#include <map>
#include <queue>
#include <cassert>
#include <string>
#include <cstring>
#include <unordered_map>
#include <unordered_set>

using namespace std;

int main(int argc, char **argv) {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int T;
    cin >> T;
    for (int caseId = 1; caseId <= T; ++caseId) {
        int u;
        cin >> u;
        vector<int> can(26, 9);
        vector<bool> with(26, false);
        vector<bool> canZero(26, true);
        for (int i = 0; i < 10000; ++i) {
            string a, b;
            cin >> a >> b;
            if (a.length() == b.length()) {
                can[b[0] - 'A'] = min(can[b[0] - 'A'], a[0] - '0');
            }
            for (char c : b) {
                with[c - 'A'] = true;
            }
            if (b.length() > 1)
                canZero[b[0] - 'A'] = false;
        }
        vector<int> chars;
        for (int i = 0; i < 26; ++i) {
            if (with[i])
                chars.push_back(i);
        }
        sort(chars.begin(), chars.end(), [can, canZero](const int &a, const int &b) {
            if (can[a] != can[b])
                return can[a] < can[b];
            return canZero[b] < canZero[a];
        });
        string answer(10, '0');
        for (int i = (int) chars.size() - 1; i >= 0; --i) {
            int at = can[chars[i]];
            if (at == 9)
                continue;
            while (at >= 0 && answer[at] != '0')
                --at;
            assert(at >= 0);
            answer[at] = chars[i] + 'A';
        }
        for (int ch : chars) {
            if (can[ch] == 9) {
                int at = 0;
                while (at < 10 && answer[at] != '0')
                    ++at;
                assert(at < 10);
                answer[at] = ch + 'A';
            }
        }
        assert(answer.find('0') == string::npos);
        printf("Case #%d: %s\n", caseId, answer.c_str());
    }
    return 0;
}
