// This is Google's simplest C++ program.
#include <algorithm>
#include <iostream>
#include <string>
#include <unordered_map>
#include <unordered_set>
#include <utility>
#include <vector>

void runInternal() {
  int u;
  std::cin >> u;
  std::unordered_map<char, int> c_to_count;
  std::unordered_set<char> c_set;
  for (int i = 0; i < 10000; ++i) {
    long long q;
    std::string r;
    std::cin >> q >> r;
    for (char c : r) {
      c_set.insert(c);
    }
    char c = r[0];
    if (r.size() < u) c = ' ';
    c_to_count[c]++;
  }
  std::vector<std::pair<char, int>> vec;
  vec.reserve(c_to_count.size());
for (auto p : c_to_count) {
    vec.push_back(p);
  }
  std::sort(vec.begin(), vec.end(),
            [](std::pair<char, int> lhs, std::pair<char, int> rhs) {
              return lhs.second > rhs.second;
            });
  std::vector<std::pair<char, bool>> present;
  present.reserve(c_set.size());
for (auto c : c_set) {
    present.push_back(std::make_pair(c, false));
  }
  for (auto& p : present) {
    bool okay = false;
    for (auto p_in : vec) {
      if (p.first == p_in.first) {
        okay = true;
      }
    }
    p.second = okay;
  }
  char c0;
  for (auto p : present) {
    if (!p.second) {
      c0 = p.first;
    }
  }
  std::string res;
  for (auto p : vec) {
    if (p.first == ' ') {
      res += c0;
    } else {
      res += p.first;
    }
  }
  std::cout << res << std::endl;
}

void run() {
  int T;
  std::cin >> T;
  for (int ca = 1; ca <= T; ++ca) {
    std::cout << "Case #" << ca << ": ";
    runInternal();
  }
}

int main(int argc, char** argv) {
  run();
  return 0;
}
