#include <iostream>
#include <vector>
#include <algorithm>
#include <set>

#ifdef INJECT_INPUT
#include <fstream>
#endif

using namespace std;

#define FOR(index, from, to) for (int index = (from); index < (to); ++index)
#define TIME_START std::chrono::steady_clock::time_point begin = std::chrono::steady_clock::now()
#define TIME_END cerr << "took " << std::chrono::duration_cast<std::chrono::milliseconds>(std::chrono::steady_clock::now() - begin).count() << " ms" << std::endl; begin = std::chrono::steady_clock::now()


bool even(long i)
{
    return abs(i) % 2 == 0;
}

void solve()
{
    long U;
    cin >> U;
    
    int freq[26];
    for (int i = 0; i < 26; i++)
        freq[i] = 0;

    int freqLast[26];
    for (int i = 0; i < 26; i++)
        freqLast[i] = 0;


    
    for (int i = 0; i < 10000; i++)
    {
        long Q;
        cin >> Q;
        string R;
        cin >> R;
        
        char c = R[0] - 'A';
        freq[c]++;

        char cLast = R[R.size()-1] - 'A';
        freqLast[cLast]++;
    }
    
    string result;
    
    for (int i = 0; i < 9; i++)
    {
        int max = 0;
        char bestletter = 0;
        
        for (int j = 0; j < 26; j++)
        {
            if (freq[j] > max)
            {
                max = freq[j];
                bestletter =j;
            }
        }
        
        freq[bestletter] = 0;
        freqLast[bestletter] = 0;
        result += (char)(bestletter + 'A');
        
    }
    
    for (int j = 0; j < 26; j++)
    {
        if (freqLast[j] > 0)
        {
            cout << (char)(j + 'A');
            break;
        }
    }

    cout << result << endl;



}



int main(int argc, char** argv)
{
    
#ifdef INJECT_INPUT
    ifstream in = ifstream("input.txt");
    cin.rdbuf(in.rdbuf());
#endif

    int T;
    cin >> T;
    
    for (int t = 0; t < T; t++)
    {
        cout << "Case #" << t+1 << ": ";
        solve();
    }
}
