#include <cstdio>
#include <cstring>
#include <cmath>

#include <algorithm>
#include <iostream>
#include <string>
#include <vector>
#include <utility>

using namespace std;

int main() {
    int nT;
    scanf("%d", &nT);

    for (int iTest = 0; iTest < nT; ++iTest) {
        int u;
        scanf("%d", &u);

        static constexpr size_t MAXN = 30;
        vector<int> counters1(MAXN);
        vector<int> counters2(MAXN);
        for (size_t i = 0; i < 10000; ++i) {
            int x;
            char buffer[100];
            scanf("%d %s", &x, buffer);
            ++counters1[buffer[0] - 'A'];
            const auto len = strlen(buffer);
            for (size_t j = 0; j < len; ++j) {
                ++counters2[buffer[j] - 'A'];
            }
        }

        for (size_t i = 0; i < MAXN; ++i) {
            if (counters1[i] == 0 && counters2[i] != 0) {
                counters1[i] = 100000000;
            }
        }

        vector<int> indexes(MAXN);
        for (size_t i = 0; i < MAXN; ++i) {
            indexes[i] = i;
        }

        sort(indexes.begin(), indexes.end(),
             [&](int index1, int index2) { return counters1[index1] > counters1[index2]; });

        printf("Case #%d: ", iTest + 1);
        for (size_t i = 0; i < MAXN; ++i) {
            if (counters1[indexes[i]]) {
                printf("%c", 'A' + indexes[i]);
            }
        }
        printf("\n");
    }

    return 0;
}
