
#include <vector>
#include <iostream>
#include <string>
#include <map>
#include <unordered_map>
#include <unordered_set>

#include <algorithm>

using namespace std;

using ll = long long;

struct Info{
    char c; int count;
};

bool infoCmp(const Info& a,const Info&b){
    return a.count > b.count;
}

string doTest(int U,vector<ll>& Q,vector<string>& R){
    unordered_map<char,int> counts;
    unordered_set<char> all;
    for(const string& r:R){
        if(r.size()==U){
            char c = r[0];
            if(counts.find(c)==counts.end()){
                counts[c]=0;
            }
            ++counts[c];
        }
        for(char c:r){
            all.insert(c);
        }
    }
    vector<Info> infos;
    for(auto pair:counts){
        infos.push_back({pair.first,pair.second});
    }
    std::sort(infos.begin(),infos.end(),infoCmp);
    string result;
    for(auto info:infos){
        result += info.c;
    }
    for(char c:all){
        if(counts.find(c)==counts.end()){
            result = c+result;
        }
    }
    return result;
}

void doOverRand(){
    int T;
    cin>>T;
    for(int t = 1;t<=T;++t){
        int U;
        cin >> U;
        vector<ll> Q;
        vector<string> R;
        for(int i = 0;i<10000;++i){
            ll q;
            string r;
            cin>>q>>r;
            Q.push_back(q);
            R.push_back(r);
        }
        string answer = doTest(U,Q,R);
        std::cout<<"Case #"<<t<<": "<<answer<<std::endl;
    }
}

int main() {

    doOverRand();
    return 0;
}