#include <iostream>
#include <cstdio>
#include <string>
#include <cstring>
#include <deque>
#include <list>
#include <queue>
#include <stack>
#include <vector>
#include <utility>
#include <algorithm>
#include <map>
#include <set>
#include <complex>
#include <cmath>
#include <limits>
#include <climits>
#include <ctime>
#include <cassert>
#include <numeric>
#include <functional>
#include <bitset>

using namespace std;
using lint = long long int;
long long int INF = 1001001001001001LL;
int inf = 1000000007;
long long int MOD = 1000000007LL;
double PI = 3.1415926535897932;

template<typename T1,typename T2>inline void chmin(T1 &a,const T2 &b){if(a>b) a=b;}
template<typename T1,typename T2>inline void chmax(T1 &a,const T2 &b){if(a<b) a=b;}

#define ALL(a) a.begin(),a.end()
#define RALL(a) a.rbegin(),a.rend()

/* do your best */

void printCase(int testcase) {
  cout << "Case #" << testcase + 1 << ": ";
}

pair<int, int> culc_keta(lint m) {
  int keta = 0;
  int num;
  
  while (m > 0) {
    keta++;
    num = m;
    m /= 10;
  }

  return make_pair(keta, num);

}

void solve() {
  set<char> alpha;
  int u; cin >> u;
  vector<pair<int, string>> info;

  for (int i = 0; i < 10000; i++) {
    lint m;
    string r;
    cin >> m >> r;


    for (auto x : r) {
      alpha.insert(x);
    }

    if (m != -1) {
      info.push_back({m, r});
    }
  }

  sort(ALL(info));

  vector<char> ans;
  assert(alpha.size() == 10);
  for (auto c : alpha) {
    ans.push_back(c);
  }

  do {
    bool ok = true;
    for (int i = 0; i < 10000; i++) {
      lint m;
      string r;
      tie(m, r) = info[i];
      
      int keta;
      int num;
      tie(keta, num) = culc_keta(m);

      if (keta == r.size()) {
        // 情報あり！！
        int ub = num;
        int lb = 1;

        // [lb, rb] が r[0] である可能性がある
        bool exist = false;
        for (int j = lb; j <= ub; j++) {
          if (ans[j] == r[0]) exist = true;
        }
        
        if (!exist) {
          ok = false;
          break;
        }
      }
    }

    if (!ok) continue;
    
    for (int i = 0; i < 10; i++) {
      cout << ans[i];
    }
    cout << endl;
    return;

  } while (next_permutation(ALL(ans)));

}

int main() {
  
  int t; cin >> t;
  for (int i = 0; i < t; i++) {
    printCase(i);
    solve();
  }
  return 0;
}
