#include <bits/stdc++.h>

#define mp make_pair
#define pb push_back
#define sz(x) ((int)(x).size())
#define forn(i, n) for(int i=0;i<(n);++i)
#define clr(ar, val) memset(ar, val, sizeof(ar))

using namespace std;

typedef long double ld;
typedef pair<int, int> pii;
typedef pair<long long, long long> pll;
typedef pair<ld, ld> point;

const int MAXN = int(2e5) + 200;
const int INF = int(1e9) + 10;
const long long LINF = 1LL * INF * INF;
const int md = int(1e9) + 7;
const ld eps = 1e-9;
const ld PI = 3.1415926535897932384626433832795l;

const int reqnum = 10000;
int test, maxlen;
vector<pair<string, string>> reqs(reqnum);
map<char, set<int>> res;
map<char, set<int>> bad;
set<char> good;

vector<vector<int>> gr;
vector<int> mt;
vector<char> used;
int n, k;

void add_edge(char x, int l, int r) {
    for (int i = l; i <= r; ++i) {
        res[x].insert(i);
    }
}

void add_edges(string m, string r) {
    if (r.length() < m.length() || m[0] == '-') {
        add_edge(r[0], 1, 9);
        for (int i = 1; i < r.length(); ++i) {
            add_edge(r[i], 0, 9);
        }
    } else {
        add_edge(r[0], 1, m[0] - '1' + 1);
        for (int i = 1; i < r.length(); ++i) {
            add_edge(r[i], 0, 9);
        }
    }
}

bool try_kuhn(int v) {
    if (used[v]) {
        return false;
    }
    used[v] = true;
    for (size_t i = 0; i < gr[v].size(); ++i) {
        int to = gr[v][i];
        if (mt[to] == -1 || try_kuhn(mt[to])) {
            mt[to] = v;
            return true;
        }
    }
    return false;
}

int main() {
    //freopen("input.txt", "r", stdin);
    //freopen("output.txt", "w", stdout);
    ios::sync_with_stdio(false);
    cin.tie(0);
    cin >> test;
    for (int it = 0; it < test; ++it) {
        res.clear(); bad.clear(); good.clear();
        cin >> maxlen;
        for (int i = 0; i < reqnum; ++i) {
            cin >> reqs[i].first >> reqs[i].second;
            add_edges(reqs[i].first, reqs[i].second);
            bad[reqs[i].second[0]].insert(0);
        }

        for (int x = 1; x < 10; ++x) {
            bool ok = false;
            for (int i = 0; i < reqnum; ++i) {
                if (reqs[i].first[0] != '-' && reqs[i].first[0] == char('0' + x) &&
                    reqs[i].first.length() == reqs[i].second.length() &&
                    good.find(reqs[i].second[0]) == good.end()) {
                    ok = true;
                    good.insert(reqs[i].second[0]);
                    for (int cur = 0; cur < 10; ++cur) {
                        if (cur != x) {
                            bad[reqs[i].second[0]].insert(cur);
                        }
                    }
                }
            }
        }

        for (auto p : bad) {
            for (auto x : p.second) {
                res[p.first].erase(x);
            }
        }

        // kuhn
        gr.clear(); mt.clear(); used.clear();
        n = 26; k = 10;
        gr.resize(n);
        int cntss = 0;
        for (auto p : res) {
            for (auto x : p.second) {
                gr[p.first - 'A'].push_back(x);
                ++cntss;
            }
        }
        //cout << cntss << endl;
        mt.assign(k, -1);
        for (int v = 0; v < n; ++v) {
            used.assign(n, false);
            try_kuhn(v);
        }
        for (int i = 0; i < k; ++i) {
            if (mt[i] == -1) {
                for (int j = 0; j < 26; ++j) {
                    if (res.find(char('A' + j)) == res.end()) {
                        mt[i] = j;
                        res[char('A' + j)].insert(1);
                        break;
                    }
                }
            }
        }
        string ans;
        for (int i = 0; i < k; ++i) {
            ans += char('A' + mt[i]);
        }
        cout << "Case #" << it + 1 << ": " << ans << endl;
    }
    return 0;
}
