#include <iostream>
#include <algorithm>
#include <vector>
#include <iterator>
#include <set>
#include <string>

bool noFirst(char number, char letter, std::string &result, std::vector<bool> &known, std::set<char> &used, std::vector<std::set<char>> &cannot) {
    if (known[number - '1' + 1]) {
        if (result[number - '1' + 1] != letter) {
            result[0] = letter;
            known[0] = true;
            used.insert(letter);
        }

        return true;
    }

    for (int k = number - '1' + 2; k < 10; k++) {
        cannot[k].insert(letter);
    }

    if (known[number - '1'] && known[0]) {
        result[number - '1' + 1] = letter;
        known[number - '1' + 1] = true;
        used.insert(letter);
        return true;
    }
    
    int index = -1;
    for (int i = 0; i < number - '1' + 1; i++) {
        if (known[i]) {
            continue;
        }

        if (cannot.at(i).find(letter) == cannot.at(i).end()) {
            if (index != -1) {
                index = -1;
                break;
            }

            index = i;
        }
    }

    if (index != -1) {
        result[index] = letter;
        known[index] = true;
        used.insert(letter);
        return true;
    }

    return false;
}

int main(void) {
    long long t;
    std::cin >> t;

    for (long long i = 0; i < t; i++) {
        long long u;
        std::cin >> u;
        std::set<char> allChar;
        std::set<char> used;
        std::vector<std::set<char>> cannot(10, std::set<char>());
        std::vector<bool> known(10, false);
        std::string result = "----------";
        std::vector<std::pair<long long, std::string>> input;
        for (long long j = 0; j < 10000; j++) {
            long long q;
            std::string s;
            std::cin >> q >> s;
            input.push_back({q, s});
        }

        std::sort(input.begin(), input.end());
        for (auto &curr : input) {
            long long q = curr.first;
            std::string s = curr.second;
            cannot[0].insert(s[0]);
            std::string qString = std::to_string(q);
            for (char c : s) {
                allChar.insert(c);
            }

            if (q != -1 && qString.length() == s.length()) {
                for (int k = qString[0] - '1' + 2; k < 10; k++) {
                    cannot[k].insert(s[0]);
                }

                if (known[qString[0] - '1']) {
                    result[qString[0] - '1' + 1] = s[0];
                    known[qString[0] - '1' + 1] = true;
                    used.insert(s[0]);
                    int index = 1;
                    while (noFirst(qString[index], s[index], result, known, used, cannot)) {
                        index++;
                    }
                }
            }
        }

        if (cannot[0].size() == 9) {
            std::vector<char> avail;
            std::set_difference(allChar.begin(), allChar.end()
              , cannot.at(0).begin(), cannot.at(0).end()
              , std::inserter(avail, avail.begin()));
            result[0] = avail.at(0);
            used.insert(avail.at(0));
        }

        for (int j = 9; j >= 0; j--) {
            if (result[j] != '-') {
                continue;
            }

            std::vector<char> avail;
            std::set_difference(allChar.begin(), allChar.end()
              , cannot.at(j).begin(), cannot.at(j).end()
              , std::inserter(avail, avail.begin()));
            std::set_difference(avail.begin(), avail.end()
              , used.begin(), used.end()
              , std::inserter(avail, avail.begin()));
            result[j] = avail.at(0);
            used.insert(avail.at(0));
        }

        std::cout << "Case #" << i + 1 << ": " << result << std::endl;
    }
    
    return 0;
}

