#include <bits/stdc++.h>
using namespace std;

int nrDigits(int64_t x) {
    int cnt = 0;
    while (x) {
        cnt++;
        x /= 10;
    }
    return cnt;
}

int firstDigit(int64_t x) {
    while (x > 9)
        x /= 10;
    return x;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    random_device rnd;
    mt19937_64 eng(rnd());

    int t; cin >> t;
    for (int it = 1; it <= t; it++) {
        int u; cin >> u;
        vector<int64_t> pwr(u + 1);
        pwr[0] = 1;
        for (int i = 1; i <= u; i++)
            pwr[i] = pwr[i - 1] * 10;

        vector<bool> used(26);
        vector<set<char>> chrs(10);

        for (int i = 0; i < 10000; i++) {
            int64_t q; cin >> q;
            string str; cin >> str;
            for (char chr : str)
                used[chr - 'A'] = true;
            if (q == -1) {
                uniform_int_distribution<int64_t> dis(pwr[str.size() - 1], pwr[u] - 1);
                q = dis(eng);
            }
            if (nrDigits(q) == (int) str.size())
                chrs[firstDigit(q)].insert(str[0]);
        }

        string ans = "**********";
        for (int i = 1; i < 10; i++)
            for (char chr : chrs[i]) {
                bool ok = true;
                for (int j = 1; j < i; j++)
                    if (ans[j] == chr) {
                        ok = false;
                        break;
                    }
                if (ok) {
                    ans[i] = chr;
                    break;
                }
            }
        for (char chr = 'A'; chr <= 'Z'; chr++)
            if (used[chr - 'A']) {
                bool ok = true;
                for (int i = 1; i < 10; i++)
                    if (ans[i] == chr) {
                        ok = false;
                        break;
                    }
                if (ok) {
                    ans[0] = chr;
                    break;
                }
            }
        cout << "Case #" << it << ": " << ans << '\n';
    }
    return 0;
}
