#include <algorithm>
#include <bitset>
#include <cmath>
#include <iomanip>
#include <iostream>
#include <fstream>
#include <functional>
#include <limits>
#include <list>
#include <map>
#include <numeric>
#include <queue>
#include <regex>
#include <set>
#include <sstream>
#include <stack>
#include <string>
#include <tuple>
#include <unordered_set>
#include <vector>

class Problem {
  private:
    int U;
    std::vector<std::pair<long long int, std::string>> data;
  public:
    void ReadInput(std::istream& input) {
      input>>U;
      for (auto i=0;i<10000;++i) {
        std::pair<long long int,std::string> e;
        input>>e.first>>e.second;
        data.push_back(e);
      }
    }

    void Solve(std::ostream& output) {
      std::set<char> nz;
      std::set<char> comp;

      for (auto e:data) {
        if (e.second.size()<U) nz.emplace(e.second[0]);
        for (auto c:e.second) comp.emplace(c);
      }

      char z;

      for (auto e:comp) if (nz.find(e)==nz.end()) z=e;

      std::map<char,int> rs;

      for (auto e:data) {
        auto d=e.first;
        auto l=1;

        while (d>=10) {
          d/=10;
          ++l;
        }

        if (e.second.size()==l)
          if (rs.find(e.second[0])==rs.end()) rs[e.second[0]]=d; else rs[e.second[0]]=std::min(rs[e.second[0]],(int)d);
      }

      std::map<int,char> r;

      r[0]=z;
      for (auto e:rs) r[e.second]=e.first;

      for (auto p:r) output<<p.second;
    }                                                               
};

int main() {
  int T;

  std::cin>>T;

  for (auto index=1;index<=T;++index) {
    Problem problem;

    problem.ReadInput(std::cin);

    std::cout<<"CASE #"<<index<<": ";
    problem.Solve(std::cout);
    std::cout<<std::endl;
  }

  return 0;
}