#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <cmath>
using namespace std;

bool apply_new_char(vector<string>& mapping, int digit, char tchar)
{
    bool ready = true, exist = false;
    cout << "digit=" << digit << " - tchar=" << tchar << "\n";

    for (int i=0; i<10; ++i)
    {
        if (i<=digit)
        {
            if (mapping[i].find(tchar)!=string::npos)   //exist
            {
                exist = true;
                continue;
            }
        }
        else
        {
            if (exist == true)
            {
                auto it=mapping[i].begin();
                while (it!=mapping[i].end())
                {
                    if (*it==tchar)
                        it = mapping[i].erase(it);
                    else
                        ++it;
                }
            }
            else
            {
                if (i==digit) mapping[i].push_back(tchar);
            }
        }
        if (mapping[i].size()!=1)
            ready = false;
        cout << mapping[i];
    }
    cout << "\n";
    return ready;
}

string rand_mapping(vector<pair<long long,string>>& QR)
{
    vector<string> mapping(10, "");
    for (auto& qr: QR)
    {
        do {
            long long digit = qr.first % 10;
            char      tchar = qr.second.back();
            if (qr.first < 10)  //single digit
            {
                if (apply_new_char(mapping, digit, tchar))
                {
                    string str;
                    for (const auto& s:mapping)
                        str.append(s);
                    return str;
                }
            }
            qr.first /= 10;
            qr.second.pop_back();
        } while (qr.first > 0 && !qr.second.empty());
    }
    return "";
}


int main()
{
    int T, U;
    vector<pair<long long,string>> QR;
    long long q;
    string r;
    QR.reserve(10000);
    cin >> T;
    for (int t=0; t<T; ++t)
    {
        QR.clear();
        cin >> U;
        for (int i=0; i<10000; ++i)
        {
            cin >> q;
            cin >> r;
            if (q == -1) q = pow(10, U) - 1;
            QR.push_back(make_pair(q,r));
        }
        cout << "Case #" << (t+1) << ": " << rand_mapping(QR) << "\n";
    }
    return 0;
}
