#include <algorithm>
#include <iomanip>
#include <istream>
#include <map>
#include <numeric>
#include <ostream>
#include <set>
#include <sstream>
#include <string>
#include <utility>
#include <vector>
#include <memory>
using namespace std;
// Powered by caide (code generator, tester, and library code inliner)

using ll = long long;

constexpr ll INF = INT64_MAX / 2;

struct State {
	std::map<ll, ll> c;
	ll total;
	ll offset;

	void TruncateTo(ll new_total) {
		while (new_total < total) {
			auto it = c.end();
			--it;
			ll step = min(it->second, total - new_total);
			it->second -= step;
			if (it->second == 0) {
				c.erase(it);
			}
			total -= step;
		}
	}
};

std::unique_ptr<State> MergeStates(std::unique_ptr<State> left, std::unique_ptr<State> right) {
	if (left->c.size() < right->c.size())
		swap(left, right);
	left->total += right->total;
	for (const auto& el : right->c) {
		left->c[el.first + right->offset - left->offset] += el.second;
	}
	if (left->total > INF) {
		left->TruncateTo(INF);
	}
	return left;
}

class Solution {
public:
	int n;
	vector<int> parent;
	vector<ll> capacity, price;

	vector<vector<int>> edges;

	std::unique_ptr<State> Get(int p) {
		std::unique_ptr<State> res(new State());
		if (p != 0) {
			res->c[0] = INF;
			res->total = INF;
		}
		for (const auto& child : edges[p]) {
			res = MergeStates(std::move(res), Get(child));
		}
		res->offset += price[p];
		res->TruncateTo(capacity[p]);
		return res;
	}

    void solve(std::istream& in, std::ostream& out) {
		in >> n;
		parent.resize(n, -1);
		capacity.resize(n);
		capacity[0] = INT64_MAX;
		price.resize(n);
		edges.resize(n);
		for (int i = 0; i < n - 1; ++i) {
			int u, v, s, c;
			in >> u >> v >> s >> c;
			--u, --v;
			parent[v] = u;
			capacity[v] = s;
			price[v] = c;
			edges[u].push_back(v);
		}
		auto res = Get(0);
		ll z = 0;
		for (const auto& pr : res->c) {
			z += (pr.first + res->offset) * pr.second;
		}
		out << res->total << " " << z << endl;
    }
};

void solve(std::istream& in, std::ostream& out)
{
    out << std::setprecision(12);
	int testCases;
	in >> testCases;
	for (int i = 1; i <= testCases; ++i) {
		Solution solution;
		out << "Case #" << i << ": ";
		solution.solve(in, out);
	}
}


#include <fstream>
#include <iostream>


int main() {
    
    ios_base::sync_with_stdio(false);
    cin.tie(0);


    istream& in = cin;


    ostream& out = cout;

    solve(in, out);
    return 0;
}


