#include <bits/stdc++.h>

using namespace std;

#ifdef LOCAL
    #define eprintf(...) fprintf(stderr, __VA_ARGS__)
#else
    #define eprintf(...) 42
#endif

using ll = long long;
using ld = long double;
using D = double;
using uint = unsigned int;
template<typename T>
using pair2 = pair<T, T>;

#define pb push_back
#define mp make_pair
#define all(x) (x).begin(),(x).end()
#define fi first
#define se second

const int maxn = 100005;

const int inf = 1e9;

struct tedge
{
	int to, cap, cost;
};

vector<tedge> gr[maxn];
int n;

struct tans
{
	ll cnt;
	map<ll, ll> m;
};

using pans = tans*;

pans merge(pans a, pans b)
{
	if (a->m.size() > b->m.size()) swap(a, b);
	for (auto t : a->m) b->m[t.fi] += t.se;
	b->cnt += a->cnt;
	return b;
}

pans go(int cur, ll cost = 0, int cap = inf)
{
	pans curans = new tans;
	curans->cnt = 0;
	
	for (auto e : gr[cur])
	{
		auto ret = go(e.to, e.cost + cost, min(cap, e.cap));
		curans = merge(curans, ret);
	}
	
	if (cur != 0)
	{
		while (curans->cnt > cap)
		{
			auto it = prev(curans->m.end());
			ll rem = min(it->se, curans->cnt - cap);
			if (rem == it->se)
			{
				curans->m.erase(it);
			} else
			{
				it->se -= rem;
			}
			curans->cnt -= rem;
		}
		if (cur != 0)
		{
			ll add = cap - curans->cnt;
			while (!curans->m.empty())
			{
				auto it = prev(curans->m.end());
				if (it->fi <= cost) break;
				add += it->se;
				curans->cnt -= it->se;
				curans->m.erase(it);
			}
			if (add > 0)
			{
				curans->m[cost] += add;
				curans->cnt += add;
			}
		}
	}
	return curans;
}

void solve()
{
	scanf("%d", &n);
	for (int i = 0; i < n; i++) gr[i].clear();
	for (int i = 0; i < n - 1; i++)
	{
		int a, b;
		scanf("%d%d", &a, &b);
		a--, b--;
		int cap, cost;
		scanf("%d%d", &cap, &cost);
		gr[a].pb({b, cap, cost});
	}
	auto res = go(0);
	ll cnt = 0;
	ll ttcost = 0;
	for (auto t : res->m)
	{
		cnt += (ll)t.se;
		ttcost += (ll)t.fi * t.se;
	}
	assert(cnt == res->cnt);
	printf(" %lld %lld\n", cnt, ttcost);
}

int main()
{
    int NT = 0;
    scanf("%d", &NT);
    for (int T = 1; T <= NT; T++)
    {
        printf("Case #%d:", T);
        
        solve();

        fprintf(stderr, "%d/%d cases done!\n", T, NT);
    }
    return 0;
}
