#include <iostream>
 #include <map>
 #include <vector>
 
 int nCases;
 int nDistance;
 int nLocations;
 std::vector<int> vLocations;
 std::map<int, int> mVendorsAtLocation;
 double nMinTimeRequired;
 
 void reset()
 {
 	vLocations.clear();
 	mVendorsAtLocation.clear();
 	nMinTimeRequired = 0;
 }
 
 void read_input()
 {
 	std::cin >> nLocations;
 	std::cin >> nDistance;
 	for (int i = 0; i < nLocations; i++)
 	{
 		int nLocation;
 		int nVendors;
 		std::cin >> nLocation;
 		std::cin >> nVendors;
 		vLocations.push_back(nLocation);
 		mVendorsAtLocation[nLocation] = nVendors;
 	}
 }
 
 bool conflict(int iLeft, int iRight)
 {
 	return vLocations[iRight] - vLocations[iLeft] < nDistance;
 }
 
 double timeToResolve(int iLeft, int iRight)
 {
 	return (nDistance - (vLocations[iRight] - vLocations[iLeft])) / 2.0;
 }
 
 double timetoResolveVendors(int iLocation)
 {
 	double ret = (double)((int)(mVendorsAtLocation[vLocations[iLocation]] / 2)) * nDistance;
 	if (mVendorsAtLocation[iLocation] % 2 == 0)
 		ret -= (nDistance / 2);
 	return ret;
 }
 
 void solve_input()
 {
 	double totalTime = 0;
 	double minTime = 0;
 	for (int i = 0; i < nLocations - 1; i++)
 	{
 		double vendorTime = timetoResolveVendors(i);
 		if (conflict(i, i+1))
 		{
 			double time = timeToResolve(i, i+1);
 			totalTime += time + vendorTime;
 		}
 		else if (vendorTime != 0)
 		{
 			totalTime += vendorTime;
 		}
 		else if (totalTime != 0)
 		{
 			if (minTime < totalTime)
 				minTime = totalTime;
 			totalTime = 0;
 		}
 	}
 	if (totalTime != 0 && minTime < totalTime)
 		minTime = totalTime;
 	nMinTimeRequired = minTime;
 }
 
 void print_solution(int nCase)
 {
 	std::cout.precision(12);
 	std::cout << "Case #" << (nCase + 1) << ": " << nMinTimeRequired << std::endl;
 }
 
 int main()
 {
 	std::cin >> nCases;
 	for (int i = 0; i < nCases; i++)
 	{
 		reset();
 		read_input();
 		solve_input();
 		print_solution(i);
 	}
 	return 0;
 }
