#include <algorithm>
 #include <iostream>
 #include <vector>
 #include <stdint.h>
 
 using namespace std;
 
 double hotdog(const vector<int> &v, int d, int totalVendors);
 int gcd(int a, int b);
 
 int main(int argc, char** argv) {
     int t;
     cin >> t;
     for (int i = 0; i < t; ++i) {
         int totalVendors = 0;
         int c, d;
         cin >> c >> d;
         vector<int> vendors;
         for (int j = 0; j < c; ++j) {
             int p, v;
             cin >> p >> v;
             totalVendors += v;
             for (; v > 0; --v) {
                 vendors.push_back(p);
             }
         }
         double answer = hotdog(vendors, d, totalVendors);
         cout << "Case #" << (i + 1) << ": " << answer << endl;
     }
     return 0;
 }
 
 double hotdog(const vector<int> &v, int d, int totalVendors) {
     int64_t distTotal = d * (totalVendors - 1);
     vector<int> vendors(v);
     sort(vendors.begin(), vendors.end());
     double maxTime = 0.0;
 
     // Move outer vendors until no vendors are left
     while (distTotal > 0) {
         vector<int>::iterator first = vendors.begin();
         vector<int>::iterator last = vendors.end() - 1;
         int currentDist = *last - *first;
         int diff = distTotal - currentDist;
         double time = (double) diff / 2;
         if (time > maxTime) {
             maxTime = time;
         }
         vendors.erase(vendors.begin());
         vendors.erase(vendors.end() - 1);
         distTotal -= 2 * d;
     }
 
     // Okay, now we need to find and eliminate all clusters.
     vector<int>::iterator it;
     vendors = v;
     double lastInCluster = *vendors.begin();
     int numInCluster = 0;
     int distInCluster = d * 2;
     double timeInCluster = 0.0;
     double totalClusterTime = 0.0;
 
     for (it = vendors.begin(); it != vendors.end(); ++it) {
         int current = *it;
         int dist = current - lastInCluster;
         // Cluster isn't far enough apart. Space them out.
         if (dist + distInCluster < d) {
             int distNeeded = d * numInCluster;
             ++numInCluster;
             double eachWalk = (double) distNeeded / 2;
             lastInCluster = current + eachWalk;
             distInCluster += d;
             if (eachWalk > timeInCluster) {
                 timeInCluster = eachWalk;
             }
         }
         // Okay, add to new cluster.
         else {
             lastInCluster = current;
             numInCluster = 1;
             distInCluster = 0;
             totalClusterTime += timeInCluster;
             timeInCluster = 0.0;
         }
     }
     // Account for time of last cluster.
     totalClusterTime += timeInCluster;
     if (totalClusterTime > maxTime) {
         maxTime = totalClusterTime;
     }
 
     return maxTime;
 }
 
 int gcd(int a, int b) {
     if (b == 0) {
         return a;
     }
     return gcd(b, a % b);
 }
