#include <iostream>
 #include <iomanip>
 #include <cstdio>
 #include <string>
 #include <algorithm>
 
 using namespace std;
 
 typedef struct {
     int p;
     int v;
 } vendor_conf;
 
 #define MAX_DIST 0xFFFFFFF
 
 bool vendor_sort(vendor_conf a, vendor_conf b)
 {
     return (a.p < b.p);
 }
 
 int main() 
 {
     freopen("in.txt", "r", stdin);
     freopen("out.txt", "w", stdout);
 
     int cases;
     cin >> cases;
     for (int caseno=1;caseno<=cases;caseno++) {
 	int c,mindist;
 	int total_vendors = 0;
 	int single_vendors = 0;
 	int stacks = 0;
 	double total_steps = 0;
 	cin >> c >> mindist;
 
         vendor_conf* points = new vendor_conf[c];
 	for (int i=0;i<c;i++) {
 	    cin >> points[i].p >> points[i].v;
 	    total_vendors += points[i].v;
 	}
 
 	sort(points, points+c, vendor_sort);
 	//int prev = points[0].p;
 	for (int i=0;i<c;i++) {
 	    //point = points[i];
 	    
 	    int dist = MAX_DIST;
 	    if (i > 0) 
 		dist = points[i].p - points[i-1].p;
 	    if (dist < mindist)
 		total_steps += (double) (mindist - dist);
 	    if (points[i].v > 1) {
 		total_steps += (double) (mindist * (points[i].v - 1));
 		stacks += points[i].v - 1;
 	    }
 	}
 
 	if (stacks < 2) stacks = 2;
 
 	double mintime = total_steps / ((double) stacks);
 	
 	cout << "Case #" << caseno << ": " << setprecision(12) << mintime << endl;
 
 	delete[] points;
 
     }
 
     return 0;
 }
