#include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
 
 #define MAX_C 0xff
 #define MAX_N 1000000
 
 int fcmp(const void *a, const void *b)
 {
 	return *(float*)a - *(float*)b;
 }
 
 int main()
 {
 	int t, t_case;
 	for (scanf("%d", &t_case), t = 1; t <= t_case; t++)
 	{
 		int c, d;
 		scanf("%d %d", &c, &d);
 
 		int i, j;
 		int p[MAX_C], v[MAX_C];
 		for (i = 0; i < c; i++)
 			scanf("%d %d", &p[i], &v[i]);
 
 		float pos[MAX_N];
 		int count = 0;
 		for (i = 0; i < c; i++)
 			for (j = 0; j < v[i]; j++)
 				pos[count++] = p[i];
 
 		qsort(pos, count, sizeof(pos[0]), fcmp);
 
 		float t_l = 0, t_r = 1e12, t_mid;
 		float pos_tmp[MAX_N];
 		while (t_r - t_l > 0.001)
 		{
 			int check = 1;
 			t_mid = (t_l + t_r) / 2;
 			memcpy(pos_tmp, pos, count * sizeof(pos[0]));
 
 			int p_l = 0, p_r = count - 1;
 
 			while (check && p_l < p_r)
 			{
 				if (p_l == 0 || pos_tmp[p_l - 1] + d <= pos_tmp[p_l] - t_mid)
 					pos_tmp[p_l] -= t_mid;
 				else if (pos_tmp[p_l - 1] + d <= pos_tmp[p_l] + t_mid)
 					pos_tmp[p_l] = pos_tmp[p_l - 1] + d;
 				else
 				{
 					check = 0;
 					break;
 				}
 
 				if (p_l < p_r)
 				{
 					if (p_r == count - 1 || pos_tmp[p_r + 1] - d >= pos_tmp[p_r] + t_mid)
 						pos_tmp[p_r] += t_mid;
 					else if (pos_tmp[p_r + 1] - d >= pos_tmp[p_r] - t_mid)
 						pos_tmp[p_r] = pos_tmp[p_r + 1] - d;
 					else
 					{
 						check = 0;
 						break;
 					}
 					if (pos_tmp[p_l] + d > pos_tmp[p_r])
 						check = 0;
 					p_r--;
 					p_l++;
 				}
 				else
 					p_l++;
 			}
 
 			if (check)
 				t_r = t_mid;
 			else
 				t_l = t_mid;
 		}
 		printf("Case #%d: %f\n", t, (float)((int)(t_l * 2 + 0.1)) / 2);
 
 	}
 	return 0;
 }
 
