#include <fstream>
 #include <vector>
 #include <cmath>
 #include <iostream>
 #include <string>
 #include <sstream>
 #include <algorithm>
 
 using namespace std;
 
 ifstream in("D:/JAM/input.txt");
 ofstream out("D:/JAM/out.txt");
 
 
 struct Pair
 {
 	int pos;
 	int qtd;
 };
 
 double solve_case(vector<Pair>& n, int d) 
 {
 	double time = 0;
 	for (int i = 0; i < n.size(); i++)
 	{
 		if (n[i].qtd >= 2)
 		{
 			time += (n[i].qtd - 1) * d / 2.0;
 			
 		}
 
 		if (i - 1 >= 0)
 		{
 				time += max(0, d - (n[i].pos - n[i - 1].pos)) / 2.0;
 		}
 	}
 
 	return time;
 }
 
 
 bool comp(Pair a, Pair b) {
 		return a.pos < b.pos;
 }
 
 int main() 
 {
 	int n_cases;
 	in >> n_cases;
 	
 	for (int i = 1; i <= n_cases; i++) {
 		int n_points;
 		in >> n_points;
 		int min_d;
 		in >> min_d;
 
 		vector<Pair> v;
 
 		for (int j = 0; j < n_points; j++) {
 			int p;
 			in >> p;
 			int qtd;
 			in >> qtd;
 			Pair pair;
 			pair.pos = p;
 			pair.qtd = qtd;
 			v.push_back(pair);
 		}
 
 		std:sort(v.begin(), v.end(), comp);
 		double time = solve_case(v, min_d);
 		out << "Case #" << i << ": " << time << endl;
 	}
 }
 
 
 
