#include <iostream>
 #include <vector>
 #include <fstream>
 #include <stdlib.h>
 #include <set>
 #include <limits.h>
 #include <iomanip>
 #include <algorithm>
 
 using namespace std;
 
 int nPoints;
 int D;
 vector< pair < int, int > > vendors;
 
 /*bool cmp(const pair<int, int> &a, const pair<int, int> &b){
 	return a.first < b.first;
 }*/
 
 int main(int argc, char *argv[]){
 	if (argc != 2){
 		cerr << "Error: " << argv[0] << " file" << endl;
 		exit(-1);
 	}
 	ifstream file(argv[1]);
 	if (!file.is_open()){
 		cerr << "Error: file " << argv[0] << " could not be opened" << endl;
 	}
 	int T;
 	file >> T;
 	int maxV = -1;
 	for (int test = 0; test < T; test++){
 		vendors.clear();
 		file >> nPoints >> D;
 		for (int i = 0; i < nPoints; i++){
 			int P, V;
 			file >> P >> V;
 			vendors.push_back(pair<int, int>(P, V));
 			if (V > maxV){
 				maxV = V;
 			}
 			//sort(vendors.begin(), vendors.end(), cmp);
 		}
 		double testTime = (maxV - 1) * D / 2.0;
 		while(1){
 			double nextFree = -testTime + vendors[0].second * D + vendors[0].first; 
 			bool errorDetected = false;
 			for (int i = 1; i < vendors.size(); i++){
 				//Todos los que podamos en ese tiempo hacia la izquierda
 				double nextFirst = -testTime + vendors[i].first;
 				if (nextFirst >= nextFree){//Sin problemas
 					nextFree = -testTime + vendors[i].second * D + vendors[i].first;
 				} else {//Lo movemos hacia la derecha
 					nextFree = -testTime + vendors[i].second * D + vendors[i].first + (nextFree - nextFirst);
 					//cuanto tarda?
 					if (nextFree - D - vendors[i].first > testTime){
 						errorDetected = true;
 						break;
 					}
 				}
 			}
 			if (errorDetected)
 				testTime += 0.1;
 			else
 				break;
 		}
 		cout << "Case #" << (test+1) << ": " << testTime << endl;
 	}
 }
