#include <iostream>
 #include <sstream>
 #include <string>
 #include <vector>
 #include <deque>
 #include <queue>
 #include <set>
 #include <map>
 #include <algorithm>
 #include <functional>
 #include <utility>
 #include <cmath>
 #include <cstdlib>
 #include <ctime>
 #include <cstdio>
 
 #include <limits.h>
 
 using namespace std;
 
 #define FOR(i,n) for((i)=0;(i)<(int)(n);(i)++)
 #define foreach(c,itr) for(__typeof((c).begin()) itr=(c).begin();itr!=(c).end();itr++)
 #define FORD(i,a,b) for((i)=(a);(i)<=(int)(b);(i)++)
 
 #define MAX_C 201
 
 struct Component
 {
 	int min;
 	int max;
 	int count;
 	double pos_max;
 	double neg_max;
 	double solve;
 	int label;
 };
 
 int c, d;
 int positions[MAX_C];
 int v[MAX_C];
 int comp[MAX_C];
 struct Component cs[MAX_C];
 int comp_count;
 
 double comp_max(struct Component& cp, int start_index)
 {
 	double middle = (cp.min + cp.max) / 2.0;
 	double left = (cp.count - 1) * (double)d / 2.0;
 	double final_pos;
 	int i;
 
 	if (cp.count == 1)
 		return 0;
 
 	cp.min = middle - left;
 	cp.max = middle + left;
 	cp.pos_max = cp.neg_max = 0;
 
 	final_pos = cp.min;
 
 	for (; start_index < c; start_index++) {
 		if (comp[start_index] != cp.label)
 			break;
 		for(i = 0; i < v[start_index]; i++) {
 			if (final_pos > positions[start_index]) {
 				cp.pos_max = max(cp.pos_max, abs(final_pos - positions[start_index]));
 			} else {
 				cp.neg_max = max(cp.neg_max, abs(final_pos - positions[start_index]));
 			}
 			final_pos += d;
 		}
 	}
 
 	cp.solve = (cp.neg_max + cp.pos_max) / 2.0;
 
 	return cp.solve;
 }
 
 int solve(int test)
 {
 	int i;
 	double result = 0.0;
 	int v_total = 0;
 	
 	cout << "Case #" << test << ": ";
 
 	cin >> c >> d;
 
 	FOR(i, c) {
 		cin >> positions[i] >> v[i];
 	}
 	
 	comp_count = 0;
 
 	FOR(i, c) {
 		if (!i) {
 			comp[i] = 0;
 			cs[0].min = positions[0];
 			cs[0].count = v[0];
 			cs[0].label = 0;
 		} else {
 			if (positions[i] - positions[i-1] < d) {
 				comp[i] = comp[i-1];
 			} else {
 				comp_count = comp[i] = comp[i-1] + 1;
 				cs[comp[i-1]].max = positions[i-1];
 				cs[comp[i]].min = positions[i];
 			}
 			cs[comp[i]].count += v[i];
 			cs[comp[i]].label = comp[i];
 		}
 
 		v_total += v[i];
 	}
 
 	cs[comp_count].max = positions[c-1];
 	comp_count++;
 
 	if (comp_count == v_total) {
 		cout << 0 << endl;
 		return 0;
 	}
 
 	result = 0;
 
 	FOR(i, c) {
 		if (!i || comp[i-1] != comp[i]) {
 			result = max(result, comp_max(cs[comp[i]], i));
 		}
 	}	
 	
  	cout.precision(8);
 	
 	cout << result << endl;
 
 	return 0;
 }
 
 int main()
 {
 	int cases = 0;
 	int i;
 
 	cin >> cases;
 
 	FOR(i, cases) {
 		solve(i + 1);
 	}
 	
 	return 0;
 }
