#include <cstdio>
 #include <iostream>
 #include <cmath>
 #include <cstring>
 #include <cstdlib>
 #include <algorithm>
 #include <vector>
 #include <string>
 #include <set>
 #include <map>
 using namespace std;
 
 vector <double> a;
 int n;
 double d;
 double eps = 1e-8;
 
 int main()
 {
 	freopen("input.txt", "r", stdin);
 	freopen("output.txt", "w", stdout);
 
 	int NTests;
 	cin >> NTests;
 
 	for (int test = 0; test < NTests; test++)
 	{
 		a.clear();
 		cin >> n >> d;
 
 		for (int i = 0; i < n; i++)
 		{
 			int p, v;
 			cin >> p >> v;
 			for (int j = 0; j < v; j++)
 				a.push_back(p);
 		}
 
 		n = a.size();
 		sort(a.begin(), a.end());
 
 		double TRight = 2000000.0;
 		double TLeft = 0;
 		double m;
 
 		while (TRight-TLeft > eps)
 		{
 			m = ((double)TRight+TLeft)/2.0;
 			double pr = a[0];
 			double cur;
 			pr -= m*(d/2);
 			
 			bool q1 = true;
 
 			for (int i = 1; i < n; i++)
 			{
 				cur = pr + d;
 				if (cur <= a[i]+eps)
 					pr = max(cur, a[i]-m*(d/2));
 				else
 				{
 					if (a[i]+m*(d/2) < cur-eps)
 					{
 						q1 = false;
 						break;
 					}
 					
 					pr = cur;
 				}
 			}
 
 			bool q2 = true;
 			
 			pr = a[n-1];
 			pr += m*(d/2);
 
 			for (int i = n-2; i >= 0; i--)
 			{
 				cur = pr - d;
 				if (cur >= a[i]-eps)
 					pr = min(cur, a[i]+m*(d/2));
 				else
 				{
 					if (a[i]-m*(d/2) > cur+eps)
 					{
 						q2 = false;
 						break;
 					}
 					
 					pr = cur;
 				}
 			}
 
 			if (q1 || q2)
 				TRight = m;
 			else
 				TLeft = m;
 		}
 		double res = (double)m;
 		cout << "Case #" << test + 1 << ": ";
 		printf("%.1f\n", res);
     }
 
 	return 0;
 }