#include <cstdio>
 #include <iostream>
 #include <cmath>
 #include <cstring>
 #include <cctype>
 #include <cstdlib>
 #include <algorithm>
 #include <vector>
 #include <string>
 #include <set>
 #include <map>
 #include <bitset>
 #include <iomanip>
 
 using namespace std;
 
 const double eps = 1e-9;
 
 bool IsOk(const vector < pair <double, double> > &p, double time, double d)
 {
 	bool res = true;
 	double Left = double(-100) * 1000 * 1000;
 
 	for (int i = 0; i < p.size(); ++i)
 	{
 		double dist = p[i].first - Left;
 
 		double left;
 		if (dist > time)
 			left = p[i].first - time;
 		else
 			left = Left;
 
 		double right = left + d * (p[i].second - 1);
 
 		Left = right + d;
 
 		if (fabs(right - p[i].first) > time || fabs(left - p[i].first) > time)
 			return false;
 	}
 
 
 	return res;
 }
 
 int main()
 {
 	freopen("input.txt", "r", stdin);
 	freopen("output.txt", "w", stdout);
 
 	int cntTest;
 	cin >> cntTest;
 
 	for (int test = 0; test < cntTest; ++test)
 	{
 		int n, d;
 		cin >> n >> d;
 
 		vector < pair < double, double > > p(n);
 		for (int i = 0; i < n; ++i)
 			cin >> p[i].first >> p[i].second;
 
 		sort(p.begin(), p.end());
 
 		double l = 0, r = (double)1000 * 1000 * 1000 * 1000;
 
 		while (r - l >= eps)
 		{
 			double m = (l + r) / 2;
 
 			if (IsOk(p, m, d))
 				r = m;
 			else
 				l = m;
 		}
 
 		cout << "Case #" << test + 1 << ": " << fixed << setprecision(10) << l << endl;
 	}
 
 	return 0;
 }