#include <vector>
 #include <list>
 #include <map>
 #include <set>
 #include <queue>
 #include <deque>
 #include <stack>
 #include <bitset>
 #include <algorithm>
 #include <functional>
 #include <numeric>
 #include <utility>
 #include <sstream>
 #include <iostream>
 #include <iomanip>
 #include <string>
 #include <cstdio>
 #include <cmath>
 #include <cstdlib>
 #include <ctime>
 #include <cstring>
  
 using namespace std;
 
 const int MAXN = 205;
 const double eps = 1e-7;
 
 int cc;
 int n, d;
 int v[MAXN];
 double p[MAXN];
 double lo, hi, adj;
 
 bool check(double m) {
     double a = (p[0] - m) + ((v[0] - 1) * d), b;
     if (fabs(p[0] - a) > m) return false;
     int i = 1;
     while (i < n) {
         if (p[i] - m < a + d) {
             b = (a + d) + ((v[i] - 1) * d);
         } else {
             b = (p[i] - m) + ((v[i] - 1) * d);
         }
         if (fabs(p[i] - b) > m) return false;
         i++;
         swap(a, b);
     }
     return true;
 }
 
 int main() {
 	freopen("input", "r", stdin);
 	freopen("output", "w", stdout);
     scanf("%d", &cc);
     for (int cas = 1; cas <= cc; cas++) {
         lo = hi = 0;
         scanf("%d%d", &n, &d);
         for (int i = 0, a, b; i < n; i++) {
             cin >> p[i] >> v[i];
             hi += v[i];
         }
         hi *= d;
         adj = (hi - lo) / 2;
         while (adj > eps) {
             if (check(lo + adj) == false) lo += adj;
             else hi -= adj;
             adj /= 2;
         }
         cout << "Case #" << cas << ": ";
         cout << setprecision(8) << fixed << lo << endl;
     }
 	return 0;
 }