#include <fstream>
 #include <vector>
 #include "math.h"
 
 double calc(double st, double d, std::vector<int> const& pos)
 {
   double res = 0;
   for (size_t i = 0; i < pos.size(); ++i)
   {
     double time = abs(pos[i] - st);
     st += d;
     if (time > res)
       res = time;
   }
 
   return res;
 }
 
 int main()
 {
 
   std::ifstream fin("input.txt");
   std::ofstream fout("output.txt");
 
   size_t n;
   fin >> n;
   
   for (size_t i = 0; i < n; ++i)
   {
     int d;
     size_t c;
     fin >> c >> d;
 
     std::vector<int> pos;
     for (size_t j = 0; j < c; ++j)
     {
       size_t v;
       int p;
       fin >> p >> v;
       for (size_t k = 0; k < v; ++k)
         pos.push_back(p);
     }
 
     double from = pos.front();
     double to   = pos.back();
 
     from -= d * pos.size();
     to += d * pos.size();
 
     double r1 = calc(from, d, pos);
     double r2 = calc(to, d, pos);
 
     while (abs(r2 - r1) > 1e-6)
     {
       double r = calc((to + from) / 2., d, pos);
       double r3 = calc((to + from) / 2. - 1e-7, d, pos);
       double r4 = calc((to + from) / 2. + 1e-7, d, pos);
       if (r3 < r)
       {
         to = (to + from) / 2.;
         r2 = r;
       }
       else
       {
         from = (to + from) / 2.;
         r1 = r;
       }
     }
 
     fout << "Case #" << (i + 1) << ": " << (r1 + r2) / 2 << std::endl;
   }
 
   fin.close();
   fout.close();
 }