#include <iostream>
 #include <vector>
 #include <cmath>
 
 using namespace std;
 
 void drawVector(const vector<double>& vendors)
 {
     for (int i = 0; i < vendors.size(); ++i)
         cout << vendors[i] << ", ";
     cout << endl << endl;
 }
 
 bool isCorrect(const vector<double>& vendors, int d)
 {
     for (int i = 0; i < vendors.size() - 1; ++i)
     {
         if (abs(vendors[i] - vendors[i + 1]) < d)
             return false;
     }
     return true;
 }
 
 double doMove(vector<double>& vendors, int d)
 {
     double movement = static_cast<double>(d) / 2;
     vendors[0] -= movement;
     vendors[vendors.size() - 1] += movement;
     for (int i = 1; i < vendors.size() - 1; ++i)
     {
         if (abs(vendors[i] - vendors[i - 1]) >= static_cast<double>(d) + movement)
             vendors[i] -= movement;
         else if (abs(vendors[i] - vendors[i + 1]) >= static_cast<double>(d) + movement)
             vendors[i] += movement;
     }
     return movement;
 }
 
 
 double doMove(vector<double>& vendors, int d, int left, const double max)
 {
     int splitPos = left;
     int splitEnd = left;
     double movement = max;
     if (left == 0 || abs(vendors[left] - vendors[left - 1] >= d + max))
     {
         for (int i = left; i < vendors.size(); ++i)
         {
             double dis = abs(vendors[i] - vendors[i + 1]);
             if (dis < d)
             {
                 splitPos = i;
                 if (movement == 0)
                     movement = (static_cast<double>(d) - dis) / 2;
                 break;
             }
         }
     }
     cout << "splitPos: " << splitPos << "; movement: " << movement << endl;
     for (int i = left; i <= splitPos; ++i)
     {
         if (i == 0 || i != left || (i == left && abs(vendors[i] - vendors[i - 1]) >= d + movement))
             vendors[i] -= movement;
     }
     for (int i = splitPos + 1; i < vendors.size(); ++i)
     {
         if (abs(vendors[i] - vendors[i - 1]) < d)
             vendors[i] += movement;
         else
         {
             splitEnd = i;
             break;
         }
     }
     if (splitEnd > left)
     {
         cout << "split move at " << splitEnd << "; max: " << movement << endl;
         drawVector(vendors);
         doMove(vendors, d, splitEnd, movement);
     }
     return movement;
 }
 
 void doTestCase(int testCase)
 {
     cout << "Case #" << testCase + 1 << ": ";
     
     int c, d;
     cin >> c;
     cin >> d;
     
     vector<double> vendors;
     for (int i = 0; i < c; ++i)
     {
         int p, v;
         cin >> p;
         cin >> v;
         for (int j = 0; j < v; ++j)
             vendors.push_back(static_cast<double>(p));
     }
 
     double time = 0;
     while (!isCorrect(vendors, d))
     {
 //        drawVector(vendors);
         time += doMove(vendors, d);//, 0, 0);
     }
 
     
     cout << time << endl;
 }
 
 int main(int argc, char* argv[])
 {
     int t;
     cin >> t;
     
     for (int i = 0; i < t; ++i)
         doTestCase(i);
 
     return EXIT_SUCCESS;
 }
