#include <iostream>
 #include <cstdio>
 #include <cstring>
 #include <cstdlib>
 #include <cmath>
 #include <string>
 #include <map>
 #include <algorithm>
 #include <vector>
 using namespace std;
 
 int nCase=1, T;
 int C, D;
 
 struct Group {
 	double L, R, T;
 	Group( double l, double r, double t ) : L(l), R(r), T(t) {}
 	Group() {}
 };
 
 vector<Group> groups;
 
 void printNow() {
 	printf("----------\n");
 	for(int i=0;i<groups.size();++i) {
 		printf("(%.2f, %.2f) need %f\n", groups[i].L, groups[i].R, groups[i].T);
 	}
 //	system("pause");
 }
 
 double calc() {
 	int i, j;
 	
 	bool domore = true;
 
 	while(domore) {
 	    domore = false;
 
 		for(i=1, j=0;i<groups.size();++i) {
 			double d = groups[i].L-groups[j].R;
 
 			if( d < D ) {
 				double dif = (D-d);
 				double T1 = groups[j].T, T2 = groups[i].T ;
 				double L = groups[j].L+T1, R = groups[i].R-T2;
 				double ndiff = (T1+T2+dif);
 
 				L = L - ndiff/2.0;
 				R = R + ndiff/2.0;
 
 				double nT = ndiff/2.0;
 				groups[j] = Group(L, R, nT);
 
 				domore = true;
 
 			} else {
 				groups[++j] = groups[i];
 			}
 		}
 		groups.resize(j+1);
 
 	}
 
 	
 	double ret = 0;
 	for(i=0;i<groups.size();++i)
 	    ret = max(ret, groups[i].T);
 	
 	return ret;
 }
 
 int main()
 {
 	scanf("%d", &T);
 	while(T-->0) {
 	    scanf("%d%d", &C, &D);
 	    groups.clear();
 	    for(int i=0;i<C;++i) {
 			double P, V;
 			scanf("%lf%lf", &P, &V);
 			groups.push_back( Group(P-D*(V-1)/2.0, P+D*(V-1)/2.0, D*(V-1)/2.0) );
 		}
 		printf( "Case #%d: %.7f\n", nCase++, calc() );
 	}
 	return 0;
 }
