////////////////////////////////////////////////////////////////////
 // Written by Hisaki Niikura
 // This source code is for Visual C++ 2010 Express
 ////////////////////////////////////////////////////////////////////
 #include <iostream>
 #include <string>
 #include <vector>
 #include <list>
 #include <queue>
 #include <map>
 #include <set>
 #include <algorithm>
 #include <sstream>
 #include <iterator>
 #include <deque>
 #include <stack>
 #include <bitset>
 #include <functional>
 #include <numeric>
 #include <utility>
 #include <iomanip>
 #include <cstdio>
 #include <cmath>
 #include <cstdlib>
 #include <cctype>
 #include <string>
 #include <cstring>
 #include <ctime>
 #include <fstream>
 
 #define	numberof(a)	(sizeof(a) / sizeof(a[0]))
 #define	INF		(1000000)
 #define Rep(i,n) for(int i = 0; i < (n); i++ )
 
 //clear memory
 #define CLR(a) memset((a), 0 ,sizeof(a))
 
 //debug
 #define dump(x)  cout << #x << " = " << (x) << endl;
 #define debug(x) cout << #x << " = " << (x) << " (L" << __LINE__ << ")" << " " << __FILE__ << endl;
 #define	show(x)	 copy( (x).begin(), (x).end(), ostream_iterator<int>(cout, ",") );
 
 using namespace std;
 
 typedef vector< vector<int> > mat;
 typedef pair<int, int> P;
 typedef long long ll;
 
 //constant
 //--------------------------------------------
 const double EPS = 1e-10;
 const double PI  = acos(-1.0);
 
 class GCJ
 {
 public:
 	double solve( int C, ll D, vector< pair<double, ll> > & input )
 	{
 		double ret = 0.0;
 		double max_t = 0.0;
 
 		for( int i = 1; i < C; i++ ){
 			// ܂͂ꂼ̓_
 			ll P = input[i].first;
 			ll V = input[i].second;
 			double t = (double)((V - 1) * D) / 2;
 			ll left_x = P - t;
 
 			ll before_P = input[i - 1].first;
 			ll before_V = input[i - 1].second;
 			double before_t = (double)((before_V - 1) * D) / 2;
 			ll before_right_x = before_P + before_t;
 
 			if( left_x - before_right_x >= D ){
 				// ok
 				max_t = max(max_t, max(t, before_t));
 			}
 			else{
 				double add_t = D - (left_x - before_right_x);// 3b
 				if( before_t < add_t ){
 					// add_t - before_t
 					add_t -= (add_t - before_t) / 2;
 				}
 				input[i].first += (add_t + t);
 				max_t = max(max_t, add_t + t);
 			}
 		}
 		ret = max_t;
 		return ret;
 	}
 };
 
 int main()
 {
 	GCJ obj;
 	vector< double > ans;
 	int T = 0;
 
 	cin >> T;
 
 	for( int t = 0; t < T; t++ ){
 		int C = 0;
 		ll D = 0;
 
 		cin >> C >> D;
 
 		vector< pair<double, ll> > input;	// (P, V)
 
 		Rep(i, C){
 			double P = 0;
 			ll V = 0;
 
 			cin >> P >> V;
 			input.push_back( make_pair(P, V) );
 		}
 
 		ans.push_back( obj.solve(C, D, input) );
 	}
 
 	// output
 	for( int i = 0; i < T; i++ ){
 		cout << "Case #" << i + 1 << ": " << ans[i] << endl;
 	}
 
 	// wait
 	cin >> T;
 
 	return 0;
 }
 
 
