#include <iostream>
 #include <sstream>
 #include <fstream>
 #include <cmath>
 #include <vector>
 #include <iomanip>
 #include <cstring>
 #include <map>
 #include <cassert>
 using namespace std;
 
 string cIntToStr(int number)
 {
    //stringstream provides an interface to manipulate strings as if they were input/output streams.
    stringstream ss;//create a stringstream
    ss << number;//add number to the stream
    return ss.str();//return a string with the contents of the stream
 }
 
 int cStrToInt(string s) 
 {
     //istringstream provides an interface to manipulate strings as input streams.
     istringstream buffer(s, istringstream::in);
     int value;
     buffer >> value;
     return value;
 }
 
 int main(int argc, char *argv[])
 {
     ifstream inFile(argv[1], ifstream::in);
     ofstream outFile(argv[2], ofstream::out);
     string sLine; int T;
 
     //The function prototype for getline is:
     //istream& getline(istream& is, string& s, char delimiter = '\n');
     //There's a conversion operator defined that converts an istream to a void*, 
     //which is further converted to a bool by using a simple != NULL rule. 
     //The void* converter will be a non-NULL value if the stream is ready and NULL if an error occurs.
     if(getline(inFile, sLine)) //!! global "getline()"
     {
         //Do here whatever you need to do
         istringstream buffer(sLine, istringstream::in);
         cout << sLine << endl;
         buffer >> T;
         //cout << T << endl;
     }
     else{
         cout << "ERROR in file format!" << endl;
         return -1;
     }
     
     for(int i = 0; i < T; i ++){
         if(getline(inFile, sLine))
         {
             istringstream buffer(sLine, istringstream::in);
             int C, D; 
             buffer >> C; 
             buffer >> D;
             
             vector<int> P; vector<int> V; vector<double> P2;
             for(int i1 = 0; i1 < C; i1 ++){
                 getline(inFile, sLine);
                 istringstream buffer2(sLine, istringstream::in);
                 int pp, vv; 
                 buffer2 >> pp; 
                 buffer2 >> vv;
                 P.push_back(pp); V.push_back(vv);
             }//for(int i1 = 0; i1 < C; i1 ++)
             //cout << "Here 1 " << endl;
             assert(V.size() == P.size());
             int sz = P.size();
             int max_dist = P[sz-1] - P[0];
             int totalV = 0;
             for(int i1 = 0; i1 < sz; i1 ++) totalV += V[i1];            
             double t1; char flag = 0; 
             if(max_dist > (totalV-1) * D) { t1 = 0.0; flag = 1; }
             else
              {   t1 = (double)((totalV-1) * D - max_dist) / 2.0; flag = 2; }
             double min_t = t1;
             //cout << "Here 2 " << endl;
             totalV -= 2;   int k = 0;         
             while(totalV > 1){
                 V[0] --; V[sz-1] --;
                 if(flag == 1)
                 {    
                     if(P2.size() == 0) {
                         P2.push_back(P[0]); P2.push_back(P[sz-1]); 
                     }
                     else{
                         P2.push_back(P[2 * (k-1)]+D); P2.push_back(P[2*(k-1)+1]-D); 
                     }
                 }
                 else
                 {    P2.push_back(P[0] - t1 * 1.0); P2.push_back(P[sz-1] + t1 * 1.0); }  
                 flag = 0;  k ++;            
                 if(V[0] == 0) { V.erase(V.begin()); P.erase(P.begin()); }
                 assert(V.size() == P.size());
                 sz = P.size(); assert(sz > 0);
                 if(V[sz-1] == 0) { V.erase(V.begin()+sz-1); P.erase(P.begin()+sz-1); }
                 assert(V.size() == P.size());
                 sz = P.size(); assert(sz > 0);
                 max_dist = P[sz-1] - P[0];
                 if(max_dist > (totalV-1) * D){ 
                     t1 = 0.0; double t11 = 0.0, t12 = 0.0;
                     if(D - (P[0] - P[2*k]) > 1e-6) t11 = D - (P[0] - P[2*k]);
                     if(D - (P[2*k+1] - P[sz-1]) > 1e-6) t12 = D - (P[2*k+1] - P[sz-1]);
                     t1 = (t11 > t12 ? t11 : t12);
                     flag = 1;
                 }
                 else
                 {    t1 = (double)((totalV-1) * D - max_dist) / 2.0; flag = 2; }
                 if(t1 > min_t) min_t = t1;
                 totalV -= 2;  
             } 
             //cout << "Here 3 " << endl;
             outFile << "Case #" << i+1 << ": "; 
             outFile << setprecision (12) << min_t << endl;
         }//if(getline(inFile, sLine))
         else{
             cout << "ERROR in file format!" << endl;
             return -1;
         }
     }//for(int i = 0; i < T; i ++)
 }
