#include <iostream> 
 #include <cstring>
 #include <cstdio>
 #include <cmath>
 #include <algorithm>
 using namespace std;
 
 int first_e[10101], e_link[20101], e_next[20101], e;
 int ind[110][110], deg[10101];
 int n, row_count, col_count;
 
 void add_edge(int x, int y) {
     deg[y] ++;
     e_link[++ e] = y, e_next[e] = first_e[x], first_e[x] = e;
 }
 
 void red(int &x1, int &y1) {
     if (x1 < 1) x1 += row_count; if (y1 < 1) y1 += col_count;
     if (x1 > row_count) x1 -= row_count; if (y1 > col_count) y1 -= col_count;
 }
 
 void init() {
     memset(first_e, 0, sizeof(first_e));
     memset(deg, 0, sizeof(deg));
     scanf("%d%d", &row_count, &col_count);
     e = 0; n = 0;
     for (int i = 1; i <= row_count; i ++)
         for (int j = 1; j <= col_count; j ++)
             ind[i][j] = ++ n;
     for (int i = 1; i <= row_count; i ++) {
         char buf[110];
         int x1, y1, x2, y2;
         scanf("%s", buf);
         for (int j = 1; j <= col_count; j ++) {
             if (buf[j-1] == '-') {
                     x1 = i, y1 = j-1, x2 = i, y2 = j+1;
                     red(x1, y1), red(x2, y2);
                     add_edge(ind[x1][y1], ind[x2][y2]);
                     add_edge(ind[x2][y2], ind[x1][y1]);
                 }
             if (buf[j-1] == '|') {
                     x1 = i-1, y1 = j, x2 = i+1, y2 = j;
                     red(x1, y1), red(x2, y2);
                     add_edge(ind[x1][y1], ind[x2][y2]);
                     add_edge(ind[x2][y2], ind[x1][y1]);
                 }
             if (buf[j-1] == '\\') {
                 x1 = i-1, y1 = j-1, x2 = i+1, y2 = j+1;
                     red(x1, y1), red(x2, y2);
                     add_edge(ind[x1][y1], ind[x2][y2]);
                     add_edge(ind[x2][y2], ind[x1][y1]);
                 }
             if (buf[j-1] == '/') {
                      x1 = i-1, y1 = j+1, x2 = i+1, y2 = j-1;
                     red(x1, y1), red(x2, y2);
                     add_edge(ind[x1][y1], ind[x2][y2]);
                     add_edge(ind[x2][y2], ind[x1][y1]);
                     break;
                 }
         }
     }
 }
 
 bool visited[10101];
 
 void dfs(int x) {//cerr<<"dfs "<<x<<endl;
     if (visited[x]) return;
     visited[x]=true;
     for (int e = first_e[x]; e > 0; e = e_next[e])
         dfs(e_link[e]);
 }
 
 void solve(int case_index) {
     printf("Case #%d: ", case_index);
     memset(visited, false, sizeof(visited));
     int ans = 1;
     for (int i = 1; i <= n; i ++) {
         if (deg[i] == 0) {printf("0\n"); return; }
         if (!visited[i]) {
             dfs(i);
             ans = ans*2 % 1000003;
           }
     }
     printf("%d\n", ans);
 }
 
 int main() {
     freopen("C-small-attempt2.in", "r", stdin);freopen("C-small.txt", "w", stdout);
     //freopen("in.txt", "r", stdin); freopen("out.txt", "w", stdout);
     int case_count;
     scanf("%d", &case_count);
     for (int i = 1; i <= case_count; i ++) {
         cerr<<i<<endl;
         init();
         solve(i);
     }
     return 0;
 }
