#include <set>
 #include <cstdio>
 #include <algorithm>
 
 using namespace std;
 
 const char dir[] = "-|\\/";
 const int dx[4] = {0, 1, 1, 1};
 const int dy[4] = {1, 0, 1, -1};
 const int MAXN = 101;
 const int MAXM = 218;
 
 char buf[MAXN][MAXN];
 int a[MAXN][MAXN], b[MAXN][MAXN];
 set<int> e[MAXN * MAXN * 2];
 bool q[MAXN * MAXN * 2];
 
 #define VAR_IN(i, j) (((i) * c + (j)) * 2)
 #define VAR_OUT(i, j) (((i) * c + (j)) * 2 + 1)
 
 const int MOD = 1000003;
 
 int bin(int n) {
 	int m = 1;
 	for (int i = 0; i < n; ++i) {
 		m += m;
 		if (m >= MOD) {
 			m -= MOD;
 		}
 	}
 	return m;
 }
 
 void dump(int s, int n) {
 	for (int i = s; i < n; ++i) {
 			printf("[%02d](%d)", i, (int)q[i]);
 			for (set<int>::const_iterator it = e[i].begin(); it != e[i].end(); ++it) {
 				printf(" %d", *it);
 			}
 			puts("");
 	}
 }
 
 int main() {
 	int re, r, c, x, y, n, ans;
 
 	scanf("%d", &re);
 	for (int ri = 1; ri <= re; ++ri) {
 		scanf("%d%d", &r, &c);
 		n = 2 * r * c;
 		for (int i = 0; i < n; ++i) {
 			e[i].clear();
 		}
 		for (int i = 0; i < r; ++i) {
 			scanf("%s", buf[i]);
 			for (int j = 0; j < c; ++j) {
 				int vi = (i * c + j) * 2;
 				int vo = vi + 1;
 				e[vi].insert(vi);
 				e[vi].insert(vo);
 				q[vi] = true;
 				q[vo] = true;
 
 				a[i][j] = find(dir, dir + 4, buf[i][j]) - dir;
 				x = (i + dx[a[i][j]] + r) % r;
 				y = (j + dy[a[i][j]] + c) % c;
 				e[(x * c + y) * 2 + 1].insert(vi);
 				x = (i - dx[a[i][j]] + r) % r;
 				y = (j - dy[a[i][j]] + c) % c;
 				e[(x * c + y) * 2 + 1].insert(vo);
 			}
 		}
 
 	//	dump(0, n);
 
 		ans = 0;
 		for (int j = 0; j < n; ++j) {
 			int i = -1;
 			for (int ii = max(0, j - MAXM); ii < n && ii <= j + MAXM; ++ii) {
 				if (!e[ii].empty() && *e[ii].begin() == j) {
 					i = ii;
 					break;
 				}
 			}
 			if (i == -1) {
 				++ans;
 				continue;
 			}
 			
 			for (int ii = i + 1; ii < n && ii <= j + MAXM; ++ii) {
 				if (!e[ii].empty() && *e[ii].begin() == j) {
 					q[ii] ^= q[i];
 					for (set<int>::const_iterator it = e[i].begin(); it != e[i].end(); ++it) {
 						pair<set<int>::iterator, bool> p = e[ii].insert(*it);
 						if (!p.second) {
 							e[ii].erase(p.first);
 						}
 					}
 				}
 			}
 		}
 
 	//	printf("ans = %d\n", ans);
 		for (int i = 0; i < n; ++i) {
 			if (e[i].empty() && q[i]) {
 				ans = -1;
 				break;
 			}
 		}
 		if (ans == -1) {
 			ans = 0;
 		} else {
 			ans = bin(ans);
 		}
 		
 		printf("Case #%d: %d\n", ri, ans % 1000003);
 	}
 
 	return 0;
 }
 
