#include <iostream>
 #include <cstring>
 #include <iomanip>
 #include <map>
 #include <utility>
 #include <algorithm>
 using namespace std;
 
 int s, m;
 const int smax = 3000, mmax = 10000;
 const int vmax = smax * smax * 4;
 int a[2 * smax - 1][2 * smax - 1];
 bool v[2 * smax - 1][2 * smax - 1];
 int x[mmax], y[mmax];
 const int dr[] = {0, 1, 1, 0, -1, -1};
 const int dc[] = {1, 1, 0, -1, -1, 0};
 int p[vmax + 6];
 int rcorn[6], ccorn[6];
 typedef pair<int, string> pis;
 
 int fn(int a) {
 	while (p[a] != a) a = p[a] = p[p[a]];
 	return a;
 }
 
 bool uf(int a, int b) {
 	a = fn(a), b = fn(b);
 	if (a == b) return false;
 	p[a] = b;
 	return true;
 }
 
 int uf0(int r, int c) {
 	int d, u = 0;
 
 	for (d = 0; d < 6; d++) {
 		int r1 = r + dr[d], c1 = c + dc[d];
 
 		if (r1 >= 0 && r1 < 2 * s - 1 && c1 >= 0 && c1 < 2 * s - 1 &&
 		 c1 < r1 + s && c1 > r1 - s) {
 			if (!a[r1][c1]) u += uf(r * (2 * s - 1) + c, r1 * (2 * s - 1) + c1);
 		} else {
 			u += uf(r * (2 * s - 1) + c, vmax);
 		}
 	}
 
 	return u;
 }
 
 int qr[vmax], qc[vmax];
 
 void walk0(int r, int c) {
 	int i, d, nq;
 
 	qr[0] = r, qc[0] = c, nq = 1;
 	v[r][c] = 1;
 	for (i = 0; i < nq; i++) {
 		uf0(qr[i], qc[i]);
 		for (d = 0; d < 6; d++) {
 			int r1 = qr[i] + dr[d], c1 = qc[i] + dc[d];
 
 			if (r1 >= 0 && r1 < 2 * s - 1 && c1 >= 0 && c1 < 2 * s - 1 &&
 			 c1 < r1 + s && c1 > r1 - s &&
 			 !a[r1][c1] &&
 			 !v[r1][c1]) {
 				qr[nq] = r1, qc[nq] = c1, nq++;
 				v[r1][c1] = 1;
 // 				cout << r1 << ',' << c1 << endl;
 			}
 		}
 	}
 }
 
 bool iscorn(int r, int c) {
 	int i;
 
 	for (i = 0; i < 6; i++) if (rcorn[i] == r && ccorn[i] == c) return true;
 	return false;
 }
 
 int uf1(int r, int c) {
 	int d, u = 0;
 	bool edge = false;
 
 	for (d = 0; d < 6; d++) {
 		int r1 = r + dr[d], c1 = c + dc[d];
 
 		if (r1 >= 0 && r1 < 2 * s - 1 && c1 >= 0 && c1 < 2 * s - 1 &&
 		 c1 < r1 + s && c1 > r1 - s) {
 			if (a[r1][c1]) u += uf(r * (2 * s - 1) + c, r1 * (2 * s - 1) + c1);
 		} else {
 			edge = true;
 		}
 	}
 	if (edge && !iscorn(r, c)) {
 		if (r == 0) {
 			// 5 o'clock edge
 			u += uf(r * (2 * s - 1) + c, vmax + 0);
 		} else if (c + 1 == r + s) {
 			// 3 o'clock
 			u += uf(r * (2 * s - 1) + c, vmax + 1);
 		} else if (c + 1 == 2 * s - 1) {
 			// 1
 			u += uf(r * (2 * s - 1) + c, vmax + 2);
 		} else if (r + 1 == 2 * s - 1) {
 			// 11
 			u += uf(r * (2 * s - 1) + c, vmax + 3);
 		} else if (c - 1 == r - s) {
 			// 9
 			u += uf(r * (2 * s - 1) + c, vmax + 4);
 		} else if (c == 0) {
 			// 7
 			u += uf(r * (2 * s - 1) + c, vmax + 5);
 		}
 	}
 
 	return u;
 }
 
 void dump() {
 	int r, c;
 	
 	for (r = 2 * s - 1; r--; ) {
 		for (c = 0; c < 2 * s - 1; c++) {
 			if (c < r + s && c > r - s) {
 				cout << setw(2) << fn(r * (2 * s - 1) + c);
 			} else {
 				cout << "  ";
 			}
 		}
 		cout << '\n';
 	}
 	for (c = 0; c < 6; c++) cout << fn(vmax + c) << ' ';
 	cout << '\n';
 }
 
 int main() {
 	int nt, it;
 
 	cin >> nt;
 	for (it = 1; it <= nt; it++) {
 		memset(a, 0, sizeof a);
 		memset(v, 0, sizeof v);
 
 		int i, j, r, c, t;
 
 		cin >> s >> m;
 		for (i = 0; i < m; i++) {
 			cin >> x[i] >> y[i];
 			a[x[i] - 1][y[i] - 1] = 1;
 		}
 
 		int nr = 0;
 		pis o[] = {{m + 1, "bridge"}, {m + 1, "fork"}, {m + 1, "ring"}};
 
 		// rings
 		for (i = 0; i < vmax + 6; i++) p[i] = i;
 		for (r = 0; r < 2 * s - 1; r++) for (c = 0; c < 2 * s - 1; c++) if (c < r + s && c > r - s) {
 			if (!a[r][c] && !v[r][c]) walk0(r, c), nr++;
 		}
 		for (i = m; i--; ) {
 // 			dump();
 			r = x[i] - 1, c = y[i] - 1;
 			a[r][c]--;
 			t = uf0(r, c);
 // 			cout << t << '\n';
 			if (t > 1) o[2].first = i + 1;
 		}
 
 		// bridges and forks
 		for (i = 0; i < 6; i++) {
 			rcorn[i] = s - 1 + dr[i] * (s - 1);
 			ccorn[i] = s - 1 + dc[i] * (s - 1);
 		}
 		for (i = 0; i < vmax + 6; i++) p[i] = i;
 		for (i = 0; i < m; i++) {
 			r = x[i] - 1, c = y[i] - 1;
 			a[r][c]++;
 			uf1(r, c);
 
 			map<int, int> pcorners, pedges;
 
 			for (j = 0; j < 6; j++) {
 				pcorners[fn(rcorn[j] * (2 * s - 1) + ccorn[j])]++;
 				pedges[fn(vmax + j)]++;
 			}
 
 			if (pcorners.size() != 6) if (o[0].first > m) o[0].first = i + 1;
 			for (map<int, int>::iterator im = pedges.begin(); im != pedges.end(); im++) {
 				if (im->second >= 3) if (o[1].first > m) o[1].first = i + 1;
 			}
 		}
 
 		cout << "Case #" << it << ':';
 // 		cout << s << ' ' << m << '\n';
 // 		cout << "nr=" << nr << " lc=" << lc;
 
 		sort(o, o + 3);
 		if (o[0].first > m) {
 			cout << " none";
 		} else {
 			for (i = 0; i < 3 && o[i].first == o[0].first; i++) {
 				cout << (i ? '-' : ' ') << o[i].second;
 			}
 			cout << " in move " << o[0].first;
 		}
 		
 		cout << endl;
 	}
 
 	return 0;
 }
