#include <iostream>
 #include <cstdio>
 #include <cstdlib>
 #include <vector>
 #include <set>
 #include <map>
 #include <string>
 #include <cstring>
 #include <cmath>
 #include <algorithm>
 #include <queue>
 
 using namespace std;
 
 int dx[6] = {1,1,0,-1,-1,0};
 int dy[6] = {1,0,1,0,-1,-1};
 
 bool was[150][150];
 vector< vector<bool > > isEmpty;
 bool isCorner[150][150];
 int isEdge[150][150];
 int s;
 int m;
 
 bool haveBridge, haveFork, haveRing;
 
 inline int getMax(int x)
 {
   if (x >= s-1)
     return 2*s-2;
   return x + s-1;
 }
 
 inline int getMin(int x)
 {
   if (x <= s-1)
     return 0;
   return x-(s-1);
 }
 
 inline bool isGood(int x, int y)
 {
   if (x < 0 || x > 2*s-2)
     return false;
   return y>=getMin(x) && y <= getMax(x);
 }
 
 inline bool DFSbridge(int x, int y, bool check = true)
 {
   was[x][y] = true;
   
   if (isCorner[x][y] && check)
     return true;
   
   for (int i = 0; i < 6; i++)
   {
     int newx = x + dx[i];
     int newy = y + dy[i];
     
     if (!isGood(newx, newy))
       continue;
     
     if (isEmpty[newx][newy])
       continue;
     
     if (was[newx][newy])
       continue;
     
     if (DFSbridge(newx, newy))
       return true;
   }
   
   return false;
 }
 
 inline void findBridge()
 {
   memset(was, 0, sizeof(was));
   for (int x = 0; x < 2*s-1; x++)
     for (int y = 0; y < 2*s-1; y++)
     {
       if (!isCorner[x][y])
 	continue;
       
       if (was[x][y])
 	continue;
       
       if (DFSbridge(x, y, false))
       {
 	haveBridge = true;
 	return;
       }
     }
 }
 
 inline void DFSring(int x, int y)
 {
   was[x][y] = true;
   
   for (int i = 0; i < 6; i++)
   {
     int newx = x + dx[i];
     int newy = y + dy[i];
     
     if (!isGood(newx, newy))
       continue;
     
     if (!isEmpty[newx][newy])
       continue;
     
     if (was[newx][newy])
       continue;
     
     DFSring(newx, newy);
   }
 }
 
 inline void findRing()
 { 
   memset(was, 0, sizeof(was));
   for (int x = 0; x < 2*s-1; x++)
     for (int y = 0; y < 2*s-1; y++)
     {
       if (was[x][y])
 	continue;
       if (!isGood(x, y))
 	continue;
       if (!isEmpty[x][y])
 	continue;
       if (isCorner[x][y] || isEdge[x][y])
 	  DFSring(x, y);
     }
     
   for (int x = 0; x < 2*s-1; x++)
     for (int y = 0; y < 2*s-1; y++) 
       if (!was[x][y] && isEmpty[x][y] && isGood(x, y))
       {
 	haveRing =  true;
 	return;
       }
 }
 
 set< int > S;
 
 inline void DFSfork(int x, int y)
 {
   was[x][y] = true;
   
   if (isEdge[x][y])
     S.insert(isEdge[x][y]);
   
   for (int i = 0; i < 6 && S.size() < 3; i++)
   {
     int newx = x + dx[i];
     int newy = y + dy[i];
     
     if (!isGood(newx, newy))
       continue;
     
     if (isEmpty[newx][newy])
       continue;
     
     if (was[newx][newy])
       continue;
     
     DFSfork(newx, newy);
   }
 }
 
 inline void findFork()
 {
   memset(was, 0, sizeof(was));
   for (int x = 0; x < 2*s-1; x++)
     for (int y = 0; y < 2*s-1; y++)
     {
       S.clear();
       if (!isGood(x, y))
 	continue;
       
       if (isEmpty[x][y])
 	continue;
       
       if (was[x][y])
 	continue;
       
       DFSfork(x, y);
       
       if (S.size() >= 3)
       {
 	haveFork = true;
 	return;
       }
     }
 }
 
 inline void initEdges()
 {
   int x, y;
   int id;
   
   
   x = 0;
   id = 234;
   for (y = 1; y < s-1; y++)
     isEdge[x][y] = id;
   
   id = 1;
   for (x = 1, y = s; y < 2*s-2; y++, x++)
     isEdge[x][y] = id;
   
   y = 2*s-2;
   id = 2;
   for (x = s; x < 2*s-2; x++)
    isEdge[x][y] = id;
   
   x = 2*s-2;
   id = 3;
   for (y = s; y < 2*s-2; y++)
     isEdge[x][y] = id;
   
   id = 4;
   for (x = s, y = 1; y < s-1; x++, y++)
     isEdge[x][y] = id;
   
   y = 0;
   id = 5;
   for (x = 1; x < s-1; x++)
     isEdge[x][y] = id;
 }
 
 
 inline void solve(int testnum)
 {
   cerr << testnum << endl;
   printf("Case #%d: ", testnum+1);
   haveBridge = haveFork = haveRing = false;
   scanf("%d", &s);
   isEmpty.assign(2*s-1, vector<bool>(2*s-1, true));
   memset(isCorner, 0, sizeof(isCorner));
   memset(isEdge, 0, sizeof(isEdge));
   
   initEdges();
   
   isCorner[0][0] = true;
   isCorner[s-1][0] = true;
   isCorner[0][s-1] = true;
   isCorner[s-1][2*s-2] = true;
   isCorner[2*s-2][s-1] = true;
   isCorner[2*s-2][2*s-2] = true;
   
   
   scanf("%d", &m);
   for (int i = 0; i < m; i++)
   {
     int x, y;
     scanf("%d%d", &x, &y);
     x--, y--;
     isEmpty[x][y] = false;
     
     findBridge();
     findFork();
     findRing();
     
     if (haveBridge || haveFork || haveRing)
     {
       string ans = "";
       if (haveBridge)
 	ans = ans + "-bridge";
       if (haveFork)
 	ans = ans + "-fork";
       if (haveRing)
 	ans = ans + "-ring";
       
       ans.erase(0,1);
       
       printf("%s in move %d\n", ans.c_str(), i+1);
       
       for (int qwe = i+1; qwe < m; qwe++)
 	scanf("%d%d", &x, &y);
       return;
     }
   }
   
   printf("none\n");
   return;
 }
 
 int main()
 {
   int testkol;
   scanf("%d\n", &testkol);
   for (int i = 0; i < testkol; i++)
     solve(i);
 }