#include <iostream>
 #include <string>
 #include <map> 
 #include <math.h>
 #include <vector>
 #include <algorithm>
 #include <cstdio>
 #include <set>
 #include <queue>
 #include <sstream>
 
 
 using namespace std;
 
 #define sqr(x) ((x)*(x))
 #define ll long long
 
 int gcd(int a, int b) {
 	while (b) b^=a^=b^=a%=b;
 	return a;
 }
 
 const int maxn=6100;
 const int dx[6]={-1,-1,0,0,1,1};
 const int dy[6]={-1,0,-1,1,0,1};
 const string ans[8]={"","bridge","fork","bridge-fork","ring","bridge-ring","fork-ring","bridge-fork-ring"};
 
 int s,m;
 int a[maxn][maxn],br[6],fr[6];
 bool vis[maxn][maxn];
 
 bool outofboard(int x, int y) {
 	if (x==0 || y==0 || x==2*s || y==2*s || abs(x-y)>=s) return 1;
 	else return 0;
 }
 
 bool check(int x, int y) { 
 	if (x==0 || y==0 || x==2*s || y==2*s || abs(x-y)>=s) return 0;
 	for (int i=0; i<6; i++) {
 		if (!a[x+dx[i]][y+dy[i]]) return false;
 	}
 	return true;
 }
 
 int findring(int x, int y) {
 	if (abs(x-y)>=s) return 0;
 	if (x==0 || y==0 || x==2*s || y==2*s) return 0;
 	vis[x][y]=1;
 	for (int i=0; i<6; i++) {
 		if (!a[x+dx[i]][y+dy[i]] && check(x+dx[i],y+dy[i])) {
 			//vis[x][y]=0;
 			return 1;
 		}
 		if (!vis[x+dx[i]][y+dy[i]] && a[x+dx[i]][y+dy[i]] && findring(x+dx[i],y+dy[i])) {
 			//vis[x][y]=0;
 			return 1;
 		}
 	}
 	//vis[x][y]=0;
 	return false;
 }
 
 void findbridge(int x, int y) {
 	if (abs(x-y)>=s) return;
 	if (x==0 || y==0 || x==2*s || y==2*s) return;
 
 	if (x==1 && y==1) br[0]=1;
 	if (x==s && y==1) br[1]=1;
 	if (x==1 && y==s) br[2]=1;
 	if (x==2*s-1 && y==s) br[3]=1;
 	if (x==s && y==2*s-1) br[4]=1;
 	if (x==2*s-1 && y==2*s-1) br[5]=1;
 
 	vis[x][y]=1;
 	for (int i=0; i<6; i++) {
 		if (!vis[x+dx[i]][y+dy[i]] && a[x+dx[i]][y+dy[i]]) findbridge(x+dx[i],y+dy[i]);
 	}
 	//vis[x][y]=0;
 }
 
 void findfork(int x, int y) {
 	if (abs(x-y)>=s) return;
 	if (x==0 || y==0 || x==2*s || y==2*s) return;
 
 	if (x==1 && y!=1 && y!=s) fr[1]=1;
 	if (y==1 && x!=1 && x!=s) fr[0]=1;
 	if (x-y==s-1 && y!=1 && y!=s) fr[2]=1;
 	if (y-x==s-1 && x!=1 && x!=s) fr[3]=1;
 	if (x==2*s-1 && y!=s && y!=2*s-1) fr[4]=1;
 	if (y==2*s-1 && x!=s && x!=2*s-1) fr[5]=1;
 
 	vis[x][y]=1;
 	for (int i=0; i<6; i++) {
 		if (!vis[x+dx[i]][y+dy[i]] && a[x+dx[i]][y+dy[i]]) findfork(x+dx[i],y+dy[i]);
 	}
 	//vis[x][y]=0;
 }
 
 void clearvis(int x, int y) {
 	vis[x][y]=0;
 	for (int i=0; i<6; i++) {
 		if (vis[x+dx[i]][y+dy[i]]) clearvis(x+dx[i],y+dy[i]);
 	}
 }
 
 void solve(int test) {
 	for (int i=0; i<maxn; i++) for (int j=0; j<maxn; j++) a[i][j]=0;
 
 	cout << "Case #" << test << ": ";
 	scanf("%d%d",&s,&m);
 	for (int cur=1; cur<=m; cur++) {
 		int x,y;
 		scanf("%d%d",&x,&y);
 		a[x][y]=1;
 
 		int bridge=0, ring=0, fork=0;
 
 		ring=findring(x,y);
 		clearvis(x,y);
 
 		for (int i=0; i<6; i++) br[i]=0;
 		findbridge(x,y);
 		clearvis(x,y);
 		int sum=0; for (int i=0; i<6; i++) sum+=br[i];
 		if (sum==2) bridge=1;
 
 		for (int i=0; i<6; i++) fr[i]=0;
 		findfork(x,y);
 		clearvis(x,y);
 		sum=0; for (int i=0; i<6; i++) sum+=fr[i];
 		if (sum==3) fork=1;
 
 		if (bridge+ring+fork) {
 			cout << ans[(bridge)+(fork?2:0)+(ring?4:0)] << " in move " << cur << endl;
 			for (int j=cur+1; j<=m; j++) {
 				int x,y;
 				scanf("%d%d",&x,&y);
 			}
 			return;
 		}
 	}
 	cout << "none" << endl;
 }
 
 int main() {
 #ifndef ONLINE_JUDGE
 	freopen("input.txt", "r", stdin);
 	freopen("output.txt", "w", stdout);
 #endif
 	int tests;
 	scanf("%d",&tests);
 	for (int test=1; test<=tests; test++) {
 		solve(test);
 	}
 
 
 	return 0;
 }