#include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
 
 #define BUF_MAX		1024
 //#define INPUT_FILE	"input.txt"
 #define INPUT_FILE	"A-small-attempt1.in"
 #define DEBUG	0
 
 double getProb(int A, int B, double* prob, int nback)
 {
 	int i;
 	double pRight=1;
 
 	for(i=0; i<A; i++){
 		if(i < (A-nback)) {
 			pRight *= prob[i];
 		} else {
 			pRight *= (1-prob[i]);
 			break;
 		}
 	}
 #if DEBUG
 	printf("getProb: nback(%d) pRight(%f)\n", nback,  pRight);
 #endif
 	return pRight;
 }
 
 int procCase(int casenum, int A, int B, double* prob)
 {
 	int i, j;
 	double p, exp, exp1;
 	int nkey, nback;
 	int n;
 
 	int cs;
 
 	double expo[BUF_MAX];
 	double min;
 	memset(expo, 0x0, sizeof(expo));
 #if DEBUG
 	printf("procCase A[%d], B[%d]\n", A, B);
 	for(i=0; i<A; i++)
 	{
 		printf("prob(%d): %f\n", i, prob[i]);
 	}	
 #endif
 	for(i=0; i<=A; i++) {
 		exp=0;
 		cs=0;
 
 		p = getProb(A, B, prob, i);
 		// 1, keep typing
 		if(i==0) {
 			nkey = B-A+1;
 		} else {
 			nkey = 2*B-A+2;
 		}
 		exp1 = ((double) nkey)*p;
 #if DEBUG
 		printf("keep typing (%d) ==> (%f)\n", nkey,exp1);
 #endif
 		expo[cs] += exp1;
 		cs ++;
 
 		// 2. backspace once
 		for(nback=1; nback<=A; nback++) {
 			if(i<1+nback) {
 				nkey = B-A+1 + 2*nback;
 			} else {
 				nkey = 2*B-A+2 + 2*nback;
 			}
 			exp1 = ((double) nkey)*p;
 
 #if DEBUG
 			printf("back space back(%d) (%d) ==> (%f)\n", nback, nkey, exp1);
 #endif
 			//exp += exp1;
 			expo[cs] += exp1;
 			cs ++;
 		}
 
 		// 3. right away
 		exp1 = (B+2) *p;
 #if DEBUG
 		printf("right away(%d)\n", B+2);
 #endif
 		//exp += exp1;
 		expo[cs] += exp1;
 		cs ++;
 		//printf("exp ==> (%f)\n", exp);
 		n = cs;
 	}
 
 	min = expo[0];
 	for(i=0; i< n; i++)
 	{
 #if DEBUG
 		printf("exp[%d] ==> (%f)\n", i, expo[i]);
 #endif
 		if(min>expo[i]) 
 			min=expo[i];
 	}
 	printf("Case #%d: %f\n", casenum+1, min);
 	return 1;
 }
 
 int main(int argc, char* argv[])
 {
 	FILE* fp;
 	char linebuf[BUF_MAX] = {0, };
 	char outbuf[BUF_MAX] = {0, };
 	char tmpbuf[BUF_MAX] = {0, };
 
 	double prob[BUF_MAX];
 	int i, numstr;
 	int A, B;
 	double f1;
 	int nn=0;
 
 	fp = fopen(INPUT_FILE, "rt");
 	if(fp == NULL) {
 		printf("file open error\n");
 		return 1;
 	}
 	fgets(linebuf, sizeof(linebuf), fp);
 	//printf("num = %s", linebuf);	
 	numstr = atoi(linebuf);
 
 	for(i=0; i<numstr; i++) {
 		memset(linebuf, 0x0, sizeof(linebuf));
 		memset(outbuf, 0x0, sizeof(outbuf));
 		memset(prob, 0x0, sizeof(prob));
 
 		fgets(linebuf, sizeof(linebuf), fp);
 		strcpy(tmpbuf, strtok(linebuf, " \r\n"));
 		A = atoi(tmpbuf);
 
 		strcpy(tmpbuf, strtok(NULL, " \r\n"));
 		B = atoi(tmpbuf);
 #if DEBUG	
 		printf("A(%d), B(%d)\n", A, B);
 #endif
 		memset(linebuf, 0x0, sizeof(linebuf));
 		fgets(linebuf, sizeof(linebuf), fp);
 
 		strcpy(tmpbuf, strtok(linebuf, " \r\n"));
 		for(i=0; i<A; i++)
 		{
 			prob[i] = atof(tmpbuf);
 		//	printf("tmpbuf[%s] prob[%d] == %f\n", 
 		//			tmpbuf, i, prob[i]);
 			if(i == (A-1)) break;
 			strcpy(tmpbuf, strtok(NULL, " \r\n"));
 		}
 		procCase(nn, A, B, prob);
 		//printf("nn(%d), numstr(%d), i(%d)\n", nn, numstr, i);
 		if(nn == (numstr-1)) break;
 		nn++;
 
 	}
 	fclose(fp);
 }
