#include <stdio.h>
 #define MAX 100001
 /* input probability */
 float p[MAX];
 /* geometric distribution */
 float prob[MAX];
 
 int count[MAX];
 
 void compute_prob(int A)
 {
 	int j;
 	float temp = 1.0;
 	float mult = 1.0;
 
 	prob[A] = 1 - p[0];
 	for (j = A-1; j > 0; j--)
 	{
 		temp = temp * p[A-1-j];
 		mult = 1.0 - p[A-j];
 		prob[j] = temp * mult;
 	}
 	prob[0] = temp * p[A-1];
 }
 
 void compute_count(int A, int B, int b)
 {
 	int j;
 
 	for (j = 0; j <= A; j++)
 	{
 		if (j <= b)
 		{
 			count[j] = B - A + 1 + (2*b);
 		}
 		else
 		{
 			count[j] = count[0] + B + 1;
 		}
 	}
 
 }
 
 float expected(int A, int B, int i)
 {
 	float temp = 0;
 	int j;
 
 	for (j = 0; j <= A; j++)
 		temp = temp + (count[j] * prob[j]);
 
 	return temp;
 }
 
 float min(int A, int B)
 {
 	int b;
 	float temp;
 	float min = B+2;
 
 	for (b = 0; b <= A; b++)
 	{
 		compute_count(A, B, b);
 		temp = expected(A, B, b);
 		if (min > temp) min = temp;
 	}
 
 	return min;
 }
 
 int main()
 {
 	int T;
 	int A, B;
 	int test;
 	int i;
 
 	scanf("%d", &T);
 	for (test = 1; test <= T; test++)
 	{
 		scanf("%d %d", &A, &B);
 		for (i = 0; i < A; i++)
 		{
 			scanf("%f", &p[i]);
 		}
 
 		compute_prob(A);
 		printf("Case #%d: %.6f\n", test, min(A, B));
 	}
 
 	return 0;
 }
