#include <stdio.h>
 
 
 /*================================================================== SYMB ===*/
 #define T_MAX     500
 #define INT_MAX_  100000
 #define STR_SZ    256
 
 #define ERR_ARGS    -1
 #define ERR_NOFILE  -2
 #define ERR_BADPAR  -3
 
 
 #define INI_PARAMS  1
 
 
 /*================================================================== DECL ===*/
 int sq_digits(int n, int b);
 
 
 /*================================================================== MAIN ===*/
 int main(int argc, char* argv[])
 {
     FILE* f_in;       /* Input file */
     
     int   T;          /* Parameters */
     int   i, j, k;    /* Indices */
     int   flag, nb, n, n1;
     int   p[9];       /* Case bases */
     
     char  str[STR_SZ];  /* Case line */
     char  mark[INT_MAX_];
 
     
     if(argc != 2) {
         return ERR_ARGS;
     }
     
     f_in = fopen(argv[1], "rb");
     if(f_in == NULL) {
         return ERR_NOFILE;
     }
     
     /* Read parameters */
     fgets(str, STR_SZ, f_in);
     if(INI_PARAMS != sscanf(str, "%d", &T)  ||  1>T  ||  T>T_MAX) {
         return ERR_BADPAR;
     }
 
     /* Get cases */
     for(i=1; i<=T; ++i) {
         fgets(str, STR_SZ, f_in);
         nb = sscanf(
             str,
             "%d %d %d %d %d %d %d %d %d",
             p, p+1, p+2, p+3, p+4, p+5, p+6, p+7, p+8
         );
         for(k=0; k<INT_MAX_; ++k) {
             mark[k] = 0;
         }
         /**/
         for(k=2; k<INT_MAX_; ++k) {
             //fprintf(stderr, "...%d\n", k);
             flag = 1;
             for(j=0; (j<nb) && flag; ++j) {
                 n = k;
                 for(n1=0; n1<INT_MAX_; ++n1) {
                     mark[n1] = 0;
                 }
                 while(mark[n]==0) {
                     mark[n]=1;
                     n  = sq_digits(n, p[j]);
                 }
                 flag = (n==1);
             }
             if(flag) {
                 break;
             }
         }
         fprintf(stdout, "Case #%d: %d\n", i, k);
         /**/
     }
     return 0;
 }
 
 
 /*================================================================== IMPL ===*/
 int sq_digits(int n, int b)
 {
     int r, k, s;
 
     if(b<2 || b>10) {
         return -1;
     }
     
     if(n<0) {
         k = -n;
     } else {
         k = n;
     }
     
     s = 0;
     do {
         r  = k%b;
         s += r*r;
         k /= b;
     } while (k!=0);
     //fprintf(stderr, "...%d\n", s);
     return s;
 }
