#include <cstdio>
 #include <cstring>
 #include <cmath>
 #include <cstdlib>
 #include <algorithm>
 #include <vector>
 
 using namespace std;
 
 const int MAX = 105;
 const int INF = 2000000000;
 
 char visited[MAX][MAX];
 int val[MAX][MAX];
 
 int numbers[MAX];
 int P,Q;
 
 int process(int s, int e)
 {
 	if(visited[s][e] != 0)
 		return val[s][e];
 
 	int low = numbers[s]+1;
 	int high = numbers[e]-1;
 
 	if(low >= high || low <= 0 || high > P)
 		return 0;
 
 	int mini = INF;
 	int i, v1, v2;
 
 	for(i=1; i<=Q; i++)
 	{
 		if(numbers[i] >= low && numbers[i] <= high)
 		{
 			v1 = process(s, i);
 			v2 = process(i, e);
 
 			if((high-low+v1+v2)<mini)
 			{
 				mini = high-low+v1+v2;
 			}
 		}
 	}
 
 	if(mini == INF)
 		mini = 0;
 	
 	visited[s][e] = 1;
 	val[s][e] = mini;
 
 	return mini;
 }
 
 
 int main(void)
 {	
 	//freopen("c:\\IO\\C-large.in", "rt", stdin);
 	//freopen("c:\\IO\\C-large_out.out", "wt", stdout);
 
 	int i, j, t;
 	int res;
 
 	scanf(" %d " ,&t);
 
 	for(i=1; i<=t; i++)
 	{
 		memset(visited, 0, sizeof(visited));
 		scanf( " %d %d" ,&P ,&Q);
 
 		for(j=1; j<=Q; j++)
 		{
 			scanf(" %d" ,&numbers[j]);
 		}
 
 		numbers[0] = 0;
 		numbers[Q+1] = P+1;
 
 		sort(numbers, numbers+Q+2);
 
 		res = 0;
 
 		res = process(0, Q+1);
 
 		printf("Case #%d: %d\n" ,i ,res);
 	
 	}
 
 
 	return 0;
 }
 
 
