#include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
 
 int get_next_prisoner(int center, int *cells_to_release, int size) {
 	int i;
 	int current_best = 0;
 	
 	for (i = 0; i < size; i++) {
 		if (cells_to_release[current_best] == -1) {
 			current_best = 1;
 		} else if (abs(cells_to_release[i] - center) < 
 				   abs(cells_to_release[current_best] - center)) {
 			current_best = i;
 		}
 	}
 	
 	return current_best;
 }
 
 int coins_to_pay(int release, int *cells, int size) {
 	int i;
 	int coins = 0;
 	
 	for (i = release - 1; i >= 0; i--) {
 		if (cells[i] != 1) {
 			coins++;
 		} else {
 			break;
 		}
 	}
 	
 	for (i = release + 1; i < size; i++) {
 		if (cells[i] != 1) {
 			coins++;
 		} else {
 			break;
 		}
 	}
 	
 	return coins;
 }
 
 int main (int argc, const char * argv[]) {
     FILE *input;
 	int cases;
 	int num_cells, num_releases;
 	int i, j;
 	int *cells_to_release;
 	int center;
 	int *cells;
 	int coins;
 	int coins1, coins2;
 	int index, release;
 	int *cells_to_release_cpy, *cells_cpy;
 	
 	input = fopen("input.in", "r");
 	
 	if (input == NULL) {
 		fprintf(stderr, "Unable to open input.in\n");
 		exit(1);
 	}
 	
 	fscanf(input, "%d\n", &cases);
 	
 	for (i = 1; i <= cases; i++) {
 		fscanf(input, "%d %d\n", &num_cells, &num_releases);
 		
 		cells_to_release = (int *) malloc(sizeof(int) * num_releases);
 		cells_to_release_cpy = (int *) malloc(sizeof(int) * num_releases);
 		cells = (int *) calloc(num_cells, sizeof(int));
 		cells_cpy = (int *) calloc(num_cells, sizeof(int));
 		
 		for (j = 0; j < num_releases; j++) {
 			fscanf(input, "%d", &cells_to_release[j]);
 		}
 		fscanf(input, "\n");
 		
 		if (num_cells % 2 == 1) {
 			center = num_cells / 2;
 			coins = 0;
 			
 			for (j = 0; j < num_releases; j++) {
 				index = get_next_prisoner(center, cells_to_release, num_releases);
 				release = cells_to_release[index] - 1;
 				cells_to_release[index] = -1;
 				coins += coins_to_pay(release, cells, num_cells);
 				cells[release] = 1;
 			}
 			
 			fprintf(stdout, "Case #%d: %d\n", i, coins);
 		} else {
 			center = num_cells / 2;
 			coins1 = 0;
 			
 			memcpy(cells_to_release_cpy, cells_to_release, sizeof(int) * num_releases);
 			memcpy(cells_cpy, cells, sizeof(int) * num_cells);
 			
 			for (j = 0; j < num_releases; j++) {
 				index = get_next_prisoner(center, cells_to_release, num_releases);
 				release = cells_to_release[index] - 1;
 				cells_to_release[index] = -1;
 				coins1 += coins_to_pay(release, cells, num_cells);
 				cells[release] = 1;
 			}
 			
 			center++;
 			coins2 = 0;
 			
 			for (j = 0; j < num_releases; j++) {
 				index = get_next_prisoner(center, cells_to_release_cpy, num_releases);
 				release = cells_to_release_cpy[index] - 1;
 				cells_to_release_cpy[index] = -1;
 				coins2 += coins_to_pay(release, cells_cpy, num_cells);
 				cells_cpy[release] = 1;
 			}
 			
 			if (coins1 < coins2) {
 				fprintf(stdout, "Case #%d: %d\n", i, coins1);
 			} else {
 				fprintf(stdout, "Case #%d: %d\n", i, coins2);
 			}
 		}
 	}
 	
     return 0;
 }
